/**
  Copyright (c) 2014 Freescale Semiconductor
  
  \file       mc_gps.c
  \brief      This file contains a coverflow animation for a 800 pixel wide display
  \author     Freescale Semiconductor
  \author     IM, b06623
  \version    1.0
  
  * History:  26/Feb/2014 - Initial Version

* Copyright (c) 2014, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
   
*/

#include "common.h"
#include "..\HIL\Graphics.h"
#include "..\HIL\Display.h"
#include "..\HIL\Flib.h"
#include "..\HAL\GALLO.h"
#include "..\SERVICES\DMAHandler.h"
#include "..\HIL\FontLibrary.h"

#include "tiny_ui.h"
#include "tiny_ui_util_nOS.h"
#include "tiny_ui_platform.h"

#include "math.h"

#include "mc_parameters.h"

#include ".\gps\GPSARROW.h"
#include ".\gps\grid.h"
#include ".\gps\bar.h"
#include "ARIAL34.h"
#include "ARIAL30.h"

#include "tuiLoader.h"

// defines to configure the movie clip
#define GPS_NUM_BUF 2
#ifndef PI
#define PI (3.141592653589793238462643)
#endif
void tui2go(Graphics_Object_t *dst, tiny_ui_buffer_t *src);
extern tiny_ui_matrix_t matrix0;
extern void PPMatrixY(float V_angle, float width, float height, float FOV, float pivotY);
void gpsPrintBar(float val);
uint8_t gpsPrint(
	Graphics_Object_t*  target,
	char* string, Font_FontType* font,int16_t xoffset, 
        uint16_t yoffset, Font_JustifyType justify, uint16_t maxWidth, uint8_t count
);

mc_gps_parameters_t mc_gps_parameters;
tiny_ui_buffer_t gpsBuffer[GPS_NUM_BUF];
tiny_ui_buffer_t txtBuffer;
int gps_currentBuffer = 0;


unsigned char vgModel_00[];
unsigned char vgModel_01[];
unsigned char vgModel_02[];
unsigned char vgModel_03[];
unsigned char vgModel_04[];

float gps_01[];
float gps_00[];
float gps_02[];
float gps_03[];
float gps_04[];

unsigned char *gps_data_array[] =
{
  vgModel_00,
  vgModel_01,
  vgModel_02,
  //vgModel_03,
  vgModel_04
};

int gpsidx = 0;

float *gps_path_array[] =
{
  gps_00,
  gps_01,
  gps_02,
  //gps_03,
  gps_04
};

float gps_path_size_array[] =
{
  4,
  5,
  4,
  //7,
  3
};

char *gps_string_array[]=
{
  "     Congress St.     ",
  " William Cannon Dr ",
  "     290 HW West     ",
  //7,
  "Highway to Hell"
};

void gps_loadNavigation(uint8_t *mapdata, float *navdata, int navdatasize);
void gps_Navigate(tiny_ui_buffer_t *drawBuffer, tiny_ui_matrix_t *matrix);
int testy = 45;
float factor = 1.3;

float testposy = 30;
void mc_gps(uint32_t CurrentFrame)
{
    uint32_t relative_fr;
    Graphics_Object_t tmp;
    tiny_ui_error_t error;
    static int toggle = 1;
    tiny_ui_matrix_t matrix;
    
    if(mc_gps_properties.frameLatch == 0u)
    {
        mc_gps_properties.frameLatch = CurrentFrame;
    }
    relative_fr = CurrentFrame - mc_gps_properties.frameLatch;
    switch(relative_fr)
    {
      case 0:
      break;
      case 1:    
        //reserve memory and initialize main layer
        //mc_gps_parameters.mode = 0; 
        
        for(int i = 0; i < GPS_NUM_BUF; ++i)
        {
          gpsBuffer[i].width	= 800;
          gpsBuffer[i].height	= 230;//260;
          gpsBuffer[1].height	= 230;
          gpsBuffer[i].stride	= gpsBuffer[i].width*2;
          gpsBuffer[i].format	= TINY_UI_RGBA4444;
          error = tiny_ui_allocate(&gpsBuffer[i]);
          if (error) while(1);
        }  
        
        txtBuffer.width	        = 400;
        txtBuffer.height	= 34;
        txtBuffer.stride	= txtBuffer.width;
        txtBuffer.format	= TINY_UI_A8;
        error = tiny_ui_allocate(&txtBuffer);
        if (error) while(1);
        
        Display_InitLayer(GPS_ARROW,GPSARROW_GObjectArray[0],(800-64)/2,117+175);
        //DCU_LayerSetHeight(GPS_ARROW, 38);
        DCU_LayerAlphaCfg(GPS_ARROW) = 2;
        DCU_LayerChromaCfg(GPS_ARROW) = 1;
        Display_FGColor(GPS_ARROW) = 0xFFFFFFFF;
        Display_BGColor(GPS_ARROW) = 0x0;
/*        
        Display_InitLayer(GPS_GRID,grid_GObjectArray[0],0,117);
        DCU_LayerAlphaCfg(GPS_GRID) = 2;
        DCU_LayerChromaCfg(GPS_GRID) = 1;
        Display_FGColor(GPS_GRID) = 0xFF222222;
        Display_BGColor(GPS_GRID) = 0x0;        
*/        
        tiny_ui_clear(&gpsBuffer[1], NULL, 0x00000000);
        tiny_ui_clear(&txtBuffer, NULL, 0x00000000);
        
        tui2go(&tmp, &txtBuffer);
        Display_InitLayer(GPS_TXT,&tmp,200,356);  
        DCU_LayerAlphaCfg(GPS_TXT) = 2;
        DCU_LayerChromaCfg(GPS_TXT) = 1;        
        Display_FGColor(GPS_TXT) = 0xFFFFFFFF;
        Display_BGColor(GPS_TXT) = 0x0;
        if(mc_gps_parameters.mode == 2)
        {
          gpsPrint(&tmp,gps_string_array[gpsidx%3],(Font_FontType*)&ARIAL30_Font,0, 0, FONT_CENTER, 0, 0); 
          gps_loadNavigation(gps_data_array[gpsidx%3],gps_path_array[gpsidx%3],gps_path_size_array[gpsidx%3]);
        }
        gpsidx++;
        
        tiny_ui_clear(&gpsBuffer[0], NULL, 0x00000000);
        gpsPrintBar(0);
        
      break;
      
      default:
        //auto mode
        if(mc_gps_parameters.mode == 2){
          if(relative_fr%600 == 0){
            tui2go(&tmp, &txtBuffer);
            gps_loadNavigation(gps_data_array[gpsidx%3],gps_path_array[gpsidx%3],gps_path_size_array[gpsidx%3]);
            tiny_ui_clear(&txtBuffer, NULL, 0x00000000);
            gpsPrint(&tmp,gps_string_array[gpsidx%3],(Font_FontType*)&ARIAL30_Font,0, 0, FONT_CENTER, 0, 0); 
            gpsidx++;
          }
        }
        else if(mc_gps_parameters.mode == 1){
          mc_gps_parameters.mode = 0;
          gps_loadNavigation(mc_gps_parameters.data,mc_gps_parameters.move,mc_gps_parameters.move_size);
          tui2go(&tmp, &txtBuffer);
          tiny_ui_clear(&txtBuffer, NULL, 0x00000000);
          gpsPrint(&tmp,mc_gps_parameters.str,(Font_FontType*)&ARIAL30_Font,0, 0, FONT_CENTER, 0, mc_gps_parameters.str_size); 
          gpsidx++;
        }
        //run at 30fps, too much for a single frame
        if(relative_fr&1)
        {
          tiny_ui_Identity(&matrix);          
          gps_Navigate(&gpsBuffer[0],&matrix);          
        }          
        else
        {
          tui2go(&tmp, &gpsBuffer[1]);
          Display_InitLayer(GPS_CENTER,&tmp,0,117);       
          DCU_LayerAlphaCfg(GPS_CENTER) = 2;
          DCU_LayerChromaCfg(GPS_CENTER) = 1;
          tiny_ui_Identity(&matrix0);
          tiny_ui_Translate(-400*(factor-1),-testposy-220*(factor-1),&matrix0);
          tiny_ui_Scale(factor,factor,&matrix0);
          PPMatrixY((0.01745329252 * (-testy)),800, 260, 0.4f, 260);    
          tiny_ui_clear(&gpsBuffer[1], NULL, 0x00000000);
          error = tiny_ui_blit(&gpsBuffer[1], &gpsBuffer[0], &matrix0, TINY_UI_BLEND_NONE, 0);
          if (error) while(1);
        }
        
        //Display_InitLayer(1,ALBUMS_GObjectArray[mc_hud_parameters.sign],380,480);
                             
      break;
    }
    
}

void mc_gps_Dispose()
{
  mc_hud_parameters.sign = 0;
  tiny_ui_free(&txtBuffer);
  for(int i =0; i<GPS_NUM_BUF; i++)
  {
    tiny_ui_free(&gpsBuffer[i]);
  }
  
  DCU_LayerDisable(GPS_GRID);
  DCU_LayerDisable(GPS_CENTER);
  DCU_LayerDisable(GPS_ARROW);
  DCU_LayerDisable(GPS_TXT);
  DCU_LayerDisable(GPS_BARTOP);
  DCU_LayerDisable(GPS_BARBOT);
}

void mc_gps_Refresh()
{

}


int gps_next(float *current, float *angle, float *target);

/* these variables for this functions: gps_loadNavigation, gps_Navigate */
float gps_bounds[4];
uint8_t *gps_mapdata;
float *gps_navdata;
int gps_navdatasize;

float gps_rotate;
float gps_move[2];
int next_item;

float gps_rotate2;
float gps_move2[2];
int next_item2;

void gps_NavigateAdvanced(void);

void gps_loadNavigation(uint8_t *mapdata, float *navdata, int navdatasize)
{
    tuiLoader_getBounds(gps_bounds, mapdata);
    gps_mapdata = mapdata;
    gps_navdata = navdata;
    gps_navdatasize = navdatasize;
    
    next_item = 0;
    gps_move[0] = navdata[0];
    gps_move[1] = navdata[1];    
    gps_rotate = 90;
    
    next_item2 = 0;
    gps_move2[0] = navdata[0];
    gps_move2[1] = navdata[1];    
    gps_rotate2 = 90;    
    mc_hud_parameters.sign = 0;
    //frames ahead
    for(int j = 0; j<60; j++){
      gps_NavigateAdvanced();
    }
}

void gps_Navigate(tiny_ui_buffer_t *drawBuffer, tiny_ui_matrix_t *matrix)
{
  //check if navigation is finished
  if((next_item+2)>=(gps_navdatasize*2))
    return;
      
  tiny_ui_clear(drawBuffer, NULL, 0x00000000);
  
  //navigate until segment is done, then advance to the next point
  gps_NavigateAdvanced();
  if(gps_next(gps_move, &gps_rotate, &gps_navdata[2+next_item]))
    next_item +=2;
    
  tiny_ui_Translate(drawBuffer->width/2,drawBuffer->height-30,matrix);
  tiny_ui_Rotate(gps_rotate-90,matrix);
  tiny_ui_Translate(-gps_bounds[0]-gps_move[0],-gps_bounds[1]-(220-gps_move[1]),matrix);
  tuiLoader_draw(gps_mapdata, drawBuffer, matrix);  
}

//this one just a bit ahead to know where to turn or stop
void gps_NavigateAdvanced(void)
{
  //check if navigation is finished active stop sign
  if((next_item2+2)>=(gps_navdatasize*2))
  {
    mc_hud_parameters.sign = 5; //stop
    return;  
  }
  //navigate until segment is done, then advance to the next point
  if(gps_next(gps_move2, &gps_rotate2, &gps_navdata[2+next_item2]))
    next_item2 +=2;
  
  {
    float angle_delta = gps_rotate - gps_rotate2;
    if(angle_delta>10)
    {
      mc_hud_parameters.sign = 4; //right 
    }else if(angle_delta<-10)
    {
      mc_hud_parameters.sign = 2; //left 
    }else
    {
      mc_hud_parameters.sign = 3; //speed    
    }
    
    
  } 
}

int gps_next(float *current, float *c_angle, float *target)
{
  float x,y,angle;
  float delta_angle;
  int idelta_angle;
  float speed;
  
  x = target[0] - current[0];
  y = target[1] - current[1];
  
  if((abs((int)x)<1) && (abs((int)y)<1))
      return 1; 
  
  //calculate the angle, some restrictions on zeros
  if(x==0)
  {
          if(y<0.0f)
                  angle = -90.0;
          else
                  angle = 90.0;						
  }
  else
  {
          angle = 360*atan(y/x)/(2*PI);
          if(x<0.0f)
                  angle += 180;
  }
  


  //try to align the angle moving towards pointing direction
  delta_angle = (angle - *c_angle);
  if(delta_angle>180) delta_angle -= 360;
  if(delta_angle<-180) delta_angle += 360;
  
  //no more than > abs(1)
  if(delta_angle>2){
    *c_angle += 2;
    //speed = 1.0;
  }
  else if(delta_angle<-2){
    *c_angle -= 2;
    //speed = 1.0;
  }    
  else{
    *c_angle += (0.1)*delta_angle;
    //speed = 1.7;
  }

  idelta_angle = abs((int)delta_angle);

  if(idelta_angle>45)
  {
    speed = ((180.0f - idelta_angle)/180.0f)*1.0f + 0.1f;   
  }
  else
  {
    speed = ((180.0f - idelta_angle)/180.0f)*2.0f + 0.1f;   
  }
  
  
  {
    float distance;
    distance = sqrt(x*x + y*y);
    gpsPrintBar(distance/2);
  }
  
  // calculate pos final values and update, movement is direction of the angle
  current[0] += speed*cos(PI*(angle)/180);
  current[1] += speed*sin(PI*(angle)/180);
  
  return 0;  	  
}

int gpsPrintwaitvar=1;
void gpsPrintwait(void)
{
  gpsPrintwaitvar = 0;    
}
uint8_t gpsPrint(
	Graphics_Object_t*  target,
	char* string, Font_FontType* font,int16_t xoffset, 
        uint16_t yoffset, Font_JustifyType justify, uint16_t maxWidth, uint8_t count
)
{
uint8_t dmachnl;
uint32_t i, length;

        // if count is 0 this is a NULL terminated string and we need to calc the count 
        if (count == 0){
          for(i=0;i<100;i++) 
          {
            if(string[i] == 0) {count = i; break;}
          }
          if(i==100)    return 1;  // there was no NULL termination
        }
        // in case we want to limit the output width, if = 0 we don't
        if (maxWidth){
          count++;
          length = maxWidth + 1;
          while (length > maxWidth) {
            count--;  
            length = Font_StringWidth((void *) string, count, font, FONT_ASCII, FONT_DMA);
          }
        }
        
        dmachnl = DMAHR_GetNextFreeChannel();
    	if (dmachnl == DMAHR_NOCHNL) 
    	{
          return 2;  // Failed to draw range due to no free DMA ch.
    	}
        else {
          gpsPrintwaitvar = 1;
        Font_Print(dmachnl, target,(void *)string , count, font, FONT_ASCII,
          FONT_FREERUN, FONT_HORIZONTAL, justify, gpsPrintwait, xoffset,yoffset);
        while(gpsPrintwaitvar) {;}
          return 0;
        }  
}

void gpsPrintBar(float val)
{
  if(val>100)
    val=100;
  
  Display_InitLayer(GPS_BARTOP,bar_GObjectArray[0],0x270,117);
  DCU_LayerAlphaCfg(GPS_BARTOP) = 2;
  DCU_LayerChromaCfg(GPS_BARTOP) = 1;
  Display_FGColor(GPS_BARTOP) = 0xFF0060B0;
  Display_BGColor(GPS_BARTOP) = 0x0;  

  Display_InitLayer(GPS_BARBOT,bar_GObjectArray[0],0x270,117);
  DCU_LayerAlphaCfg(GPS_BARBOT) = 2;
  DCU_LayerChromaCfg(GPS_BARBOT) = 1;
  Display_FGColor(GPS_BARBOT) = 0xFF444444;
  Display_BGColor(GPS_BARBOT) = 0x0;    
  
  //there are 14 levels
  val = val/7;
  
  if(val > 14)          {DCU_LayerSetHeight(GPS_BARTOP, 160);}
  else if(val < 1)      {DCU_LayerDisable(GPS_BARTOP);}  
  else  {DCU_LayerSetHeight(GPS_BARTOP, 140 + 10*((int)val-13));}
  
}


float gps_00[2*4] = {430,-107,430,-38,443,-10,571,202}; 
float gps_01[2*5] = {413,31,417,133,443,150,715,177,804,184}; 
float gps_02[2*4] = {416,-45,422,59,407,75,17,168};
float gps_03[2*7] = {444,-82,447,35,412,77,345,77,187,14,160,34,90,176};
float gps_04[2*3] = {208,-46,209,42,23,200};

unsigned char vgModel_00[] = //{0x1,0x0,0xef,0xbe,0x7,0x0,0x0,0x0,0x20,0x3,0x0,0x0,0xdc,0x0,0x0,0x0,0x2c,0x0,0x0,0x0,0xcb,0x2,0x0,0x0,0x3a,0x5,0x0,0x0,0x91,0x5,0x0,0x0,0xe4,0x6,0x0,0x0,0x3b,0x7,0x0,0x0,0x4e,0x8,0x0,0x0,0x6f,0x62,0x6a,0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0xc8,0xc8,0xc8,0x0,0x0,0x80,0xb4,0xc1,0x0,0x78,0x40,0x44,0x0,0x40,0xe,0x44,0x0,0x27,0x89,0x44,0x1,0x3,0x54,0x2,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0xa8,0x7,0x44,0x0,0x78,0x40,0x44,0x4,0x0,0x0,0x0,0x0,0x8,0x7,0x44,0x0,0x80,0x41,0x44,0x4,0x0,0x0,0x0,0x0,0x24,0xd4,0x43,0x0,0x8e,0x71,0x44,0x8,0x0,0x0,0x0,0xe1,0xf6,0xd3,0x43,0x3f,0x97,0x6f,0x44,0x6b,0xbc,0xd3,0x43,0x67,0x4d,0x6d,0x44,0x0,0x68,0xd3,0x43,0x0,0x68,0x6b,0x44,0x8,0x0,0x0,0x0,0x88,0x8,0xd3,0x43,0xf,0x43,0x69,0x44,0x7d,0x17,0xd2,0x43,0x61,0x95,0x67,0x44,0x0,0x20,0xd0,0x43,0x0,0xf6,0x65,0x44,0x8,0x0,0x0,0x0,0x83,0x28,0xce,0x43,0x9f,0x56,0x64,0x44,0x29,0x4f,0xcb,0x43,0x50,0xca,0x62,0x44,0x0,0xc,0xc7,0x43,0x0,0x92,0x60,0x44,0x8,0x0,0x0,0x0,0xa5,0x3,0xc4,0x43,0xa6,0xfd,0x5e,0x44,0xb9,0x31,0xbf,0x43,0x7c,0x9c,0x5e,0x44,0x0,0xbc,0xb9,0x43,0x0,0x84,0x5e,0x44,0x8,0x0,0x0,0x0,0x47,0x46,0xb4,0x43,0x84,0x6b,0x5e,0x44,0xe1,0x6,0xae,0x43,0x11,0xba,0x5e,0x44,0x0,0x10,0xa8,0x43,0x0,0x2a,0x5f,0x44,0x8,0x0,0x0,0x0,0x56,0x45,0x9c,0x43,0x4b,0x7,0x60,0x44,0x7b,0xbe,0x91,0x43,0xc0,0x69,0x61,0x44,0x0,0x80,0x91,0x43,0x0,0x72,0x61,0x44,0x4,0x0,0x0,0x0,0x0,0x80,0x8a,0xc1,0x0,0xa6,0x70,0x44,0x4,0x0,0x0,0x0,0x0,0x80,0xb4,0xc1,0x0,0xe8,0x70,0x44,0x4,0x0,0x0,0x0,0x0,0x40,0xa9,0xc1,0x0,0x34,0x72,0x44,0x4,0x0,0x0,0x0,0x0,0xc0,0x81,0xc1,0x0,0xcc,0x76,0x44,0x4,0x0,0x0,0x0,0x0,0x0,0x70,0xc1,0x0,0xf0,0x77,0x44,0x4,0x0,0x0,0x0,0x0,0x0,0x26,0xc1,0x0,0xb2,0x77,0x44,0x4,0x0,0x0,0x0,0x0,0x20,0x2e,0x43,0x0,0x28,0x6e,0x44,0x8,0x0,0x0,0x0,0x0,0x20,0x2e,0x43,0x0,0x28,0x6e,0x44,0xbf,0x30,0x93,0x43,0x45,0x52,0x68,0x44,0x0,0xac,0xae,0x43,0x0,0x8,0x66,0x44,0x8,0x0,0x0,0x0,0x81,0x20,0xb5,0x43,0x4b,0x7e,0x65,0x44,0x2a,0x3d,0xb9,0x43,0xf8,0x0,0x66,0x44,0x0,0xc,0xbc,0x43,0x0,0xf0,0x66,0x44,0x8,0x0,0x0,0x0,0xd6,0xda,0xbe,0x43,0x8,0xdf,0x67,0x44,0xeb,0x89,0xc0,0x43,0xd9,0x4f,0x69,0x44,0x0,0x88,0xc1,0x43,0x0,0xee,0x6a,0x44,0x8,0x0,0x0,0x0,0x29,0x84,0xc3,0x43,0x4d,0x2a,0x6e,0x44,0x0,0x6c,0xc2,0x43,0x0,0xdc,0x71,0x44,0x0,0x6c,0xc2,0x43,0x0,0xdc,0x71,0x44,0x4,0x0,0x0,0x0,0x0,0x64,0xc2,0x43,0x0,0xf6,0x71,0x44,0x4,0x0,0x0,0x0,0x0,0x64,0xc2,0x43,0x0,0x10,0x72,0x44,0x4,0x0,0x0,0x0,0x0,0xc0,0xc2,0x43,0x0,0x4a,0x82,0x44,0x4,0x0,0x0,0x0,0x0,0xc0,0xc2,0x43,0x0,0x50,0x82,0x44,0x4,0x0,0x0,0x0,0x0,0x8,0xc2,0x43,0x0,0x4d,0x88,0x44,0x4,0x0,0x0,0x0,0x0,0xf8,0xc1,0x43,0x0,0xe9,0x88,0x44,0x4,0x0,0x0,0x0,0x0,0x68,0xc4,0x43,0x0,0xf1,0x88,0x44,0x4,0x0,0x0,0x0,0x0,0x34,0xd2,0x43,0x0,0x1f,0x89,0x44,0x4,0x0,0x0,0x0,0x0,0xc4,0xd4,0x43,0x0,0x27,0x89,0x44,0x4,0x0,0x0,0x0,0x0,0xd4,0xd4,0x43,0x0,0x82,0x88,0x44,0x4,0x0,0x0,0x0,0x0,0x84,0xd5,0x43,0x0,0x7c,0x7f,0x44,0x4,0x0,0x0,0x0,0x0,0x98,0xa,0x44,0x0,0x44,0x45,0x44,0x4,0x0,0x0,0x0,0x0,0x40,0xe,0x44,0x0,0x2a,0x44,0x44,0x4,0x0,0x0,0x0,0x0,0x20,0xa,0x44,0x0,0x88,0x43,0x44,0x4,0x0,0x0,0x0,0x0,0xb6,0x8,0x44,0x0,0xe,0x41,0x44,0x4,0x0,0x0,0x0,0x0,0xa8,0x7,0x44,0x0,0x78,0x40,0x44,0x1,0x0,0x0,0x0,0x6f,0x62,0x6a,0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0xc8,0xc8,0xc8,0x0,0x97,0xff,0x21,0xc1,0x0,0xd4,0x43,0x44,0x0,0xca,0xa,0x44,0x0,0xd7,0x87,0x44,0x1,0x3,0x24,0x2,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0xa8,0x7,0x44,0x0,0x78,0x40,0x44,0x2,0x0,0x0,0x0,0x0,0x8c,0x8,0x44,0x0,0xd4,0x43,0x44,0x4,0x0,0x0,0x0,0x0,0xca,0xa,0x44,0x0,0x16,0x45,0x44,0x4,0x0,0x0,0x0,0x0,0xe4,0xd0,0x43,0x1,0x7e,0x7e,0x44,0x4,0x0,0x0,0x0,0x0,0x8c,0xd0,0x43,0x0,0xc8,0x7e,0x44,0x4,0x0,0x0,0x0,0x2,0x88,0xd0,0x43,0x0,0x1c,0x7f,0x44,0x4,0x0,0x0,0x0,0x2,0xe0,0xcf,0x43,0x0,0xd7,0x87,0x44,0x4,0x0,0x0,0x0,0x2,0x1c,0xc7,0x43,0x0,0xba,0x87,0x44,0x4,0x0,0x0,0x0,0x2,0xbc,0xc7,0x43,0x0,0x54,0x82,0x44,0x4,0x0,0x0,0x0,0x0,0xc0,0xc7,0x43,0x0,0x50,0x82,0x44,0x4,0x0,0x0,0x0,0x0,0xc0,0xc7,0x43,0xfe,0x4c,0x82,0x44,0x4,0x0,0x0,0x0,0x0,0x64,0xc7,0x43,0xfd,0x1d,0x72,0x44,0x8,0x0,0x0,0x0,0x6,0x81,0xc7,0x43,0x33,0xc2,0x71,0x44,0xcc,0xa1,0xc8,0x43,0xe0,0xf9,0x6d,0x44,0x0,0x50,0xc6,0x43,0xfd,0x31,0x6a,0x44,0x8,0x0,0x0,0x0,0x65,0x18,0xc5,0x43,0x12,0x36,0x68,0x44,0x21,0xd5,0xc2,0x43,0x33,0x32,0x66,0x44,0x0,0xd0,0xbe,0x43,0xfd,0xdb,0x64,0x44,0x8,0x0,0x0,0x0,0xdf,0xca,0xba,0x43,0xc7,0x85,0x63,0x44,0x5f,0x2d,0xb5,0x43,0x8a,0xf3,0x62,0x44,0x0,0xd8,0xad,0x43,0xfd,0x8f,0x63,0x44,0x8,0x0,0x0,0x0,0xbf,0x2b,0x92,0x43,0x57,0xde,0x65,0x44,0x0,0x38,0x2c,0x43,0xfd,0xb3,0x6b,0x44,0x0,0x38,0x2c,0x43,0xfd,0xb3,0x6b,0x44,0x4,0x0,0x0,0x0,0x3,0x30,0x2c,0x43,0xfd,0xb3,0x6b,0x44,0x4,0x0,0x0,0x0,0x7,0x28,0x2c,0x43,0xfd,0xb3,0x6b,0x44,0x4,0x0,0x0,0x0,0x2e,0xff,0xf8,0xc0,0xfd,0x1,0x75,0x44,0x4,0x0,0x0,0x0,0x97,0xff,0x21,0xc1,0xfd,0xd7,0x72,0x44,0x4,0x0,0x0,0x0,0x3,0x78,0x92,0x43,0xfd,0xe5,0x63,0x44,0x4,0x0,0x0,0x0,0x3,0x8c,0x92,0x43,0xfe,0xe3,0x63,0x44,0x4,0x0,0x0,0x0,0x3,0x9c,0x92,0x43,0xfe,0xe1,0x63,0x44,0x8,0x0,0x0,0x0,0x3,0x9c,0x92,0x43,0xfe,0xe1,0x63,0x44,0xe0,0x36,0x9d,0x43,0x5d,0x7b,0x62,0x44,0x3,0xcc,0xa8,0x43,0xfe,0xa1,0x61,0x44,0x8,0x0,0x0,0x0,0x95,0x96,0xae,0x43,0x4f,0x35,0x61,0x44,0x5c,0x9d,0xb4,0x43,0xcf,0xed,0x60,0x44,0x3,0x90,0xb9,0x43,0xfe,0x3,0x61,0x44,0x8,0x0,0x0,0x0,0xab,0x82,0xbe,0x43,0x2e,0x1a,0x61,0x44,0x40,0x3a,0xc2,0x43,0xa9,0xac,0x61,0x44,0x3,0x70,0xc3,0x43,0xfe,0x4d,0x62,0x44,0x8,0x0,0x0,0x0,0x16,0xa9,0xc7,0x43,0xa,0x81,0x64,0x44,0x68,0x4a,0xca,0x43,0xab,0xf6,0x65,0x44,0x3,0xdc,0xcb,0x43,0xfe,0x41,0x67,0x44,0x8,0x0,0x0,0x0,0x9f,0x6d,0xcd,0x43,0x52,0x8d,0x68,0x44,0x76,0x16,0xce,0x43,0x13,0xb4,0x69,0x44,0x3,0x6c,0xce,0x43,0xfe,0x9f,0x6b,0x44,0x8,0x0,0x0,0x0,0xc6,0x1d,0xcf,0x43,0x1d,0x9e,0x6f,0x44,0x3,0x78,0xcf,0x43,0xfe,0xcd,0x75,0x44,0x3,0x78,0xcf,0x43,0xfe,0xcd,0x75,0x44,0x4,0x0,0x0,0x0,0x3,0xb8,0xcf,0x43,0xfe,0xf,0x7a,0x44,0x4,0x0,0x0,0x0,0x3,0x1c,0xd4,0x43,0xfe,0x69,0x76,0x44,0x4,0x0,0x0,0x0,0x0,0x8c,0x8,0x44,0x0,0xd4,0x43,0x44,0x1,0x0,0x0,0x0,0x6f,0x62,0x6a,0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0xc8,0xc8,0xc8,0x0,0x0,0x8c,0x8,0x44,0x0,0xd4,0x43,0x44,0x0,0x8c,0x8,0x44,0x0,0xd4,0x43,0x44,0x1,0x3,0xc,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x8c,0x8,0x44,0x0,0xd4,0x43,0x44,0x6f,0x62,0x6a,0x33,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0x14,0x14,0x14,0x0,0xc3,0xbe,0x82,0xc1,0x8a,0xf8,0x41,0x44,0x7e,0x84,0xc,0x44,0x19,0x68,0x88,0x44,0x1,0x3,0x8,0x1,0x0,0x0,0x2,0x0,0x0,0x0,0x32,0x3e,0xc5,0x43,0x2d,0x38,0x82,0x44,0x4,0x0,0x0,0x0,0xaf,0xe3,0xc4,0x43,0x9a,0xe0,0x71,0x44,0x8,0x0,0x0,0x0,0xaf,0xe3,0xc4,0x43,0x9a,0xe0,0x71,0x44,0xd2,0xd6,0xc9,0x43,0x2d,0x52,0x62,0x44,0x11,0x43,0xae,0x43,0x7d,0x9e,0x64,0x44,0x8,0x0,0x0,0x0,0x50,0xaf,0x92,0x43,0xcd,0xea,0x66,0x44,0x56,0x29,0x2d,0x43,0x36,0xc0,0x6c,0x44,0x56,0x29,0x2d,0x43,0x36,0xc0,0x6c,0x44,0x4,0x0,0x0,0x0,0x58,0x4b,0x36,0xc1,0xfa,0x4b,0x76,0x44,0x4,0x0,0x0,0x0,0xc3,0xbe,0x82,0xc1,0x59,0xb3,0x71,0x44,0x4,0x0,0x0,0x0,0x4b,0xfa,0x91,0x43,0x6e,0x7f,0x62,0x44,0x8,0x0,0x0,0x0,0x4b,0xfa,0x91,0x43,0x6e,0x7f,0x62,0x44,0xf6,0xc1,0xbc,0x43,0x47,0xd7,0x5c,0x44,0x32,0x3e,0xc5,0x43,0xa5,0x42,0x61,0x44,0x8,0x0,0x0,0x0,0x6d,0xba,0xcd,0x43,0x5,0xae,0x65,0x44,0xfe,0x33,0xd0,0x43,0x50,0x45,0x67,0x44,0x4,0xe9,0xd0,0x43,0x2d,0x56,0x6b,0x44,0x8,0x0,0x0,0x0,0x8,0x9e,0xd1,0x43,0x9,0x67,0x6f,0x44,0x8b,0xf8,0xd1,0x43,0xf5,0x96,0x75,0x44,0x8b,0xf8,0xd1,0x43,0xf5,0x96,0x75,0x44,0x4,0x0,0x0,0x0,0x1f,0x19,0x8,0x44,0x8a,0xf8,0x41,0x44,0x4,0x0,0x0,0x0,0x7e,0x84,0xc,0x44,0x1c,0x72,0x44,0x44,0x4,0x0,0x0,0x0,0x12,0x8,0xd3,0x43,0x74,0xf5,0x7e,0x44,0x4,0x0,0x0,0x0,0xa,0x53,0xd2,0x43,0x19,0x68,0x88,0x44,0x4,0x0,0x0,0x0,0x2d,0x89,0xc4,0x43,0xd7,0x3a,0x88,0x44,0x1,0x0,0x0,0x0,0x6f,0x62,0x6a,0x33,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0x14,0x14,0x14,0x0,0x32,0x3e,0xc5,0x43,0x2d,0x38,0x82,0x44,0x32,0x3e,0xc5,0x43,0x2d,0x38,0x82,0x44,0x1,0x3,0xc,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x32,0x3e,0xc5,0x43,0x2d,0x38,0x82,0x44,0x6f,0x62,0x6a,0x35,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0xa6,0x69,0x0,0x0,0xe8,0xa2,0xc5,0x43,0xe9,0x63,0x46,0x44,0x43,0x88,0x9,0x44,0xe1,0xa4,0x89,0x44,0x1,0x3,0xc8,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0xe8,0xa2,0xc5,0x43,0x5f,0x4a,0x89,0x44,0x4,0x0,0x0,0x0,0xf2,0xc,0xc7,0x43,0x88,0x6c,0x81,0x44,0x8,0x0,0x0,0x0,0xf2,0xc,0xc7,0x43,0x88,0x6c,0x81,0x44,0x6a,0xfd,0xc5,0x43,0xf8,0x4f,0x7f,0x44,0x2d,0x89,0xcf,0x43,0x85,0x10,0x78,0x44,0x8,0x0,0x0,0x0,0xf0,0x14,0xd9,0x43,0x12,0xd1,0x70,0x44,0xda,0xb2,0x3,0x44,0xc5,0x74,0x4a,0x44,0xda,0xb2,0x3,0x44,0xc5,0x74,0x4a,0x44,0x4,0x0,0x0,0x0,0x49,0x39,0x1,0x44,0xfd,0x37,0x49,0x44,0x4,0x0,0x0,0x0,0xbb,0x78,0x8,0x44,0xe9,0x63,0x46,0x44,0x4,0x0,0x0,0x0,0x43,0x88,0x9,0x44,0x5c,0xa3,0x4d,0x44,0x4,0x0,0x0,0x0,0x34,0x69,0x7,0x44,0x52,0x39,0x4c,0x44,0x4,0x0,0x0,0x0,0x72,0x6f,0xd9,0x43,0xcb,0xf2,0x78,0x44,0x8,0x0,0x0,0x0,0x72,0x6f,0xd9,0x43,0xcb,0xf2,0x78,0x44,0x3c,0xa8,0xd1,0x43,0xed,0xe5,0x7d,0x44,0x3c,0xa8,0xd1,0x43,0xbf,0x2f,0x80,0x44,0x8,0x0,0x0,0x0,0x3c,0xa8,0xd1,0x43,0x88,0x6c,0x81,0x44,0x3c,0xa8,0xd1,0x43,0xe1,0xa4,0x89,0x44,0x3c,0xa8,0xd1,0x43,0xe1,0xa4,0x89,0x44,0x1,0x0,0x0,0x0,0x6f,0x62,0x6a,0x35,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0xa6,0x69,0x0,0x0,0xe8,0xa2,0xc5,0x43,0x5f,0x4a,0x89,0x44,0xe8,0xa2,0xc5,0x43,0x5f,0x4a,0x89,0x44,0x1,0x3,0xc,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0xe8,0xa2,0xc5,0x43,0x5f,0x4a,0x89,0x44};
{0x1,0x0,0xef,0xbe,0x7,0x0,0x0,0x0,0x20,0x3,0x0,0x0,0x5e,0x1,0x0,0x0,0x2c,0x0,0x0,0x0,0xcb,0x2,0x0,0x0,0x3a,0x5,0x0,0x0,0x91,0x5,0x0,0x0,0xe4,0x6,0x0,0x0,0x3b,0x7,0x0,0x0,0x4e,0x8,0x0,0x0,0x6f,0x62,0x6a,0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x97,0x2f,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0xc8,0xc8,0xc8,0x0,0x74,0x27,0x45,0x42,0x28,0x9e,0x30,0x44,0x77,0x36,0x20,0x44,0x14,0x3a,0x81,0x44,0x1,0x3,0x54,0x2,0x0,0x0,0x2,0x0,0x0,0x0,0x77,0x9e,0x19,0x44,0x28,0x9e,0x30,0x44,0x4,0x0,0x0,0x0,0x77,0xfe,0x18,0x44,0x28,0xa6,0x31,0x44,0x4,0x0,0x0,0x0,0xef,0x10,0xf8,0x43,0x27,0xb4,0x61,0x44,0x8,0x0,0x0,0x0,0xcf,0xe3,0xf7,0x43,0x67,0xbd,0x5f,0x44,0x59,0xa9,0xf7,0x43,0x8f,0x73,0x5d,0x44,0xef,0x54,0xf7,0x43,0x28,0x8e,0x5b,0x44,0x8,0x0,0x0,0x0,0x77,0xf5,0xf6,0x43,0x37,0x69,0x59,0x44,0x6c,0x4,0xf6,0x43,0x89,0xbb,0x57,0x44,0xef,0xc,0xf4,0x43,0x28,0x1c,0x56,0x44,0x8,0x0,0x0,0x0,0x71,0x15,0xf2,0x43,0xc7,0x7c,0x54,0x44,0x18,0x3c,0xef,0x43,0x78,0xf0,0x52,0x44,0xef,0xf8,0xea,0x43,0x28,0xb8,0x50,0x44,0x8,0x0,0x0,0x0,0x94,0xf0,0xe7,0x43,0xce,0x23,0x4f,0x44,0xa8,0x1e,0xe3,0x43,0xa4,0xc2,0x4e,0x44,0xef,0xa8,0xdd,0x43,0x28,0xaa,0x4e,0x44,0x8,0x0,0x0,0x0,0x35,0x33,0xd8,0x43,0xac,0x91,0x4e,0x44,0xcf,0xf3,0xd1,0x43,0x39,0xe0,0x4e,0x44,0xef,0xfc,0xcb,0x43,0x28,0x50,0x4f,0x44,0x8,0x0,0x0,0x0,0x45,0x32,0xc0,0x43,0x73,0x2d,0x50,0x44,0x6a,0xab,0xb5,0x43,0xe8,0x8f,0x51,0x44,0xef,0x6c,0xb5,0x43,0x28,0x98,0x51,0x44,0x4,0x0,0x0,0x0,0x74,0x27,0x5a,0x42,0x27,0xcc,0x60,0x44,0x4,0x0,0x0,0x0,0x74,0x27,0x45,0x42,0x28,0xe,0x61,0x44,0x4,0x0,0x0,0x0,0x74,0xc7,0x4a,0x42,0x28,0x5a,0x62,0x44,0x4,0x0,0x0,0x0,0x74,0x87,0x5e,0x42,0x28,0xf2,0x66,0x44,0x4,0x0,0x0,0x0,0x74,0x67,0x63,0x42,0x28,0x16,0x68,0x44,0x4,0x0,0x0,0x0,0x74,0xe7,0x75,0x42,0x27,0xd8,0x67,0x44,0x4,0x0,0x0,0x0,0xdd,0xf9,0x75,0x43,0x28,0x4e,0x5e,0x44,0x8,0x0,0x0,0x0,0xdd,0xf9,0x75,0x43,0x28,0x4e,0x5e,0x44,0xad,0x1d,0xb7,0x43,0x6d,0x78,0x58,0x44,0xef,0x98,0xd2,0x43,0x28,0x2e,0x56,0x44,0x8,0x0,0x0,0x0,0x70,0xa,0xd9,0x43,0x73,0xa4,0x55,0x44,0x18,0x2a,0xdd,0x43,0x20,0x27,0x56,0x44,0xef,0xf8,0xdf,0x43,0x28,0x16,0x57,0x44,0x8,0x0,0x0,0x0,0xc5,0xc7,0xe2,0x43,0x30,0x5,0x58,0x44,0xda,0x76,0xe4,0x43,0x1,0x76,0x59,0x44,0xef,0x74,0xe5,0x43,0x27,0x14,0x5b,0x44,0x8,0x0,0x0,0x0,0x18,0x71,0xe7,0x43,0x76,0x50,0x5e,0x44,0xef,0x58,0xe6,0x43,0x28,0x2,0x62,0x44,0xef,0x58,0xe6,0x43,0x28,0x2,0x62,0x44,0x4,0x0,0x0,0x0,0xef,0x50,0xe6,0x43,0x27,0x1c,0x62,0x44,0x4,0x0,0x0,0x0,0xef,0x50,0xe6,0x43,0x28,0x36,0x62,0x44,0x4,0x0,0x0,0x0,0xef,0xac,0xe6,0x43,0x28,0xba,0x74,0x44,0x4,0x0,0x0,0x0,0xef,0xac,0xe6,0x43,0x28,0xc6,0x74,0x44,0x4,0x0,0x0,0x0,0xef,0xf4,0xe5,0x43,0x14,0x60,0x80,0x44,0x4,0x0,0x0,0x0,0xef,0xe4,0xe5,0x43,0x14,0xfc,0x80,0x44,0x4,0x0,0x0,0x0,0xef,0x54,0xe8,0x43,0x14,0x4,0x81,0x44,0x4,0x0,0x0,0x0,0xef,0x20,0xf6,0x43,0x14,0x32,0x81,0x44,0x4,0x0,0x0,0x0,0xef,0xb0,0xf8,0x43,0x14,0x3a,0x81,0x44,0x4,0x0,0x0,0x0,0xef,0xc0,0xf8,0x43,0x14,0x95,0x80,0x44,0x4,0x0,0x0,0x0,0xef,0x70,0xf9,0x43,0x28,0xa2,0x6f,0x44,0x4,0x0,0x0,0x0,0x77,0x8e,0x1f,0x44,0x28,0x6a,0x35,0x44,0x4,0x0,0x0,0x0,0x77,0x36,0x20,0x44,0x28,0x50,0x34,0x44,0x4,0x0,0x0,0x0,0x77,0x16,0x1f,0x44,0x28,0xae,0x33,0x44,0x4,0x0,0x0,0x0,0x77,0xac,0x1a,0x44,0x28,0x34,0x31,0x44,0x4,0x0,0x0,0x0,0x77,0x9e,0x19,0x44,0x28,0x9e,0x30,0x44,0x1,0x0,0x0,0x0,0x6f,0x62,0x6a,0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x97,0x2f,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0xc8,0xc8,0xc8,0x0,0x8e,0xe7,0x76,0x42,0x28,0xfa,0x33,0x44,0x77,0xc0,0x1c,0x44,0x29,0xd4,0x7f,0x44,0x1,0x3,0x24,0x2,0x0,0x0,0x2,0x0,0x0,0x0,0x77,0x9e,0x19,0x44,0x28,0x9e,0x30,0x44,0x2,0x0,0x0,0x0,0x77,0x82,0x1a,0x44,0x28,0xfa,0x33,0x44,0x4,0x0,0x0,0x0,0x77,0xc0,0x1c,0x44,0x28,0x3c,0x35,0x44,0x4,0x0,0x0,0x0,0xef,0xd0,0xf4,0x43,0x29,0xa4,0x6e,0x44,0x4,0x0,0x0,0x0,0xef,0x78,0xf4,0x43,0x28,0xee,0x6e,0x44,0x4,0x0,0x0,0x0,0xf0,0x74,0xf4,0x43,0x28,0x42,0x6f,0x44,0x4,0x0,0x0,0x0,0xf0,0xcc,0xf3,0x43,0x29,0xd4,0x7f,0x44,0x4,0x0,0x0,0x0,0xf0,0x8,0xeb,0x43,0x28,0x9a,0x7f,0x44,0x4,0x0,0x0,0x0,0xf0,0xa8,0xeb,0x43,0x28,0xce,0x74,0x44,0x4,0x0,0x0,0x0,0xef,0xac,0xeb,0x43,0x28,0xc6,0x74,0x44,0x4,0x0,0x0,0x0,0xef,0xac,0xeb,0x43,0x24,0xc0,0x74,0x44,0x4,0x0,0x0,0x0,0xef,0x50,0xeb,0x43,0x24,0x44,0x62,0x44,0x8,0x0,0x0,0x0,0xf4,0x6d,0xeb,0x43,0x5c,0xe8,0x61,0x44,0xbb,0x8e,0xec,0x43,0x8,0x20,0x5e,0x44,0xef,0x3c,0xea,0x43,0x25,0x58,0x5a,0x44,0x8,0x0,0x0,0x0,0x54,0x5,0xe9,0x43,0x3a,0x5c,0x58,0x44,0x10,0xc2,0xe6,0x43,0x5b,0x58,0x56,0x44,0xef,0xbc,0xe2,0x43,0x25,0x2,0x55,0x44,0x8,0x0,0x0,0x0,0xcd,0xb7,0xde,0x43,0xef,0xab,0x53,0x44,0x4e,0x1a,0xd9,0x43,0xb2,0x19,0x53,0x44,0xef,0xc4,0xd1,0x43,0x25,0xb6,0x53,0x44,0x8,0x0,0x0,0x0,0xae,0x18,0xb6,0x43,0x7f,0x4,0x56,0x44,0xdd,0x11,0x74,0x43,0x25,0xda,0x5b,0x44,0xdd,0x11,0x74,0x43,0x25,0xda,0x5b,0x44,0x4,0x0,0x0,0x0,0xe0,0x9,0x74,0x43,0x25,0xda,0x5b,0x44,0x4,0x0,0x0,0x0,0xe4,0x1,0x74,0x43,0x25,0xda,0x5b,0x44,0x4,0x0,0x0,0x0,0xc7,0x23,0x80,0x42,0x24,0x28,0x65,0x44,0x4,0x0,0x0,0x0,0x8e,0xe7,0x76,0x42,0x25,0xfe,0x62,0x44,0x4,0x0,0x0,0x0,0xf2,0x64,0xb6,0x43,0x25,0xc,0x54,0x44,0x4,0x0,0x0,0x0,0xf2,0x78,0xb6,0x43,0x26,0xa,0x54,0x44,0x4,0x0,0x0,0x0,0xf2,0x88,0xb6,0x43,0x26,0x8,0x54,0x44,0x8,0x0,0x0,0x0,0xf2,0x88,0xb6,0x43,0x26,0x8,0x54,0x44,0xcf,0x23,0xc1,0x43,0x85,0xa1,0x52,0x44,0xf2,0xb8,0xcc,0x43,0x26,0xc8,0x51,0x44,0x8,0x0,0x0,0x0,0x83,0x83,0xd2,0x43,0x77,0x5b,0x51,0x44,0x4a,0x8a,0xd8,0x43,0xf6,0x13,0x51,0x44,0xf2,0x7c,0xdd,0x43,0x26,0x2a,0x51,0x44,0x8,0x0,0x0,0x0,0x99,0x6f,0xe2,0x43,0x56,0x40,0x51,0x44,0x2f,0x27,0xe6,0x43,0xd1,0xd2,0x51,0x44,0xf2,0x5c,0xe7,0x43,0x26,0x74,0x52,0x44,0x8,0x0,0x0,0x0,0x4,0x96,0xeb,0x43,0x35,0xa7,0x54,0x44,0x57,0x37,0xee,0x43,0xd3,0x1c,0x56,0x44,0xf2,0xc8,0xef,0x43,0x26,0x68,0x57,0x44,0x8,0x0,0x0,0x0,0x8d,0x5a,0xf1,0x43,0x7a,0xb3,0x58,0x44,0x65,0x3,0xf2,0x43,0x3b,0xda,0x59,0x44,0xf2,0x58,0xf2,0x43,0x26,0xc6,0x5b,0x44,0x8,0x0,0x0,0x0,0xb4,0xa,0xf3,0x43,0x45,0xc4,0x5f,0x44,0xf2,0x64,0xf3,0x43,0x26,0xf4,0x65,0x44,0xf2,0x64,0xf3,0x43,0x26,0xf4,0x65,0x44,0x4,0x0,0x0,0x0,0xf2,0xa4,0xf3,0x43,0x26,0x36,0x6a,0x44,0x4,0x0,0x0,0x0,0xf2,0x8,0xf8,0x43,0x26,0x90,0x66,0x44,0x4,0x0,0x0,0x0,0x77,0x82,0x1a,0x44,0x28,0xfa,0x33,0x44,0x1,0x0,0x0,0x0,0x6f,0x62,0x6a,0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x97,0x2f,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0xc8,0xc8,0xc8,0x0,0x77,0x82,0x1a,0x44,0x28,0xfa,0x33,0x44,0x77,0x82,0x1a,0x44,0x28,0xfa,0x33,0x44,0x1,0x3,0xc,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x77,0x82,0x1a,0x44,0x28,0xfa,0x33,0x44,0x6f,0x62,0x6a,0x33,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x97,0x2f,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0x14,0x14,0x14,0x0,0x12,0x8,0x5e,0x42,0xf4,0x4b,0x32,0x44,0xf6,0x7a,0x1e,0x44,0xce,0x91,0x80,0x44,0x1,0x3,0x8,0x1,0x0,0x0,0x2,0x0,0x0,0x0,0x21,0x2b,0xe9,0x43,0xc4,0xc3,0x74,0x44,0x4,0x0,0x0,0x0,0x9e,0xd0,0xe8,0x43,0x3,0x34,0x62,0x44,0x8,0x0,0x0,0x0,0x9e,0xd0,0xe8,0x43,0x3,0x34,0x62,0x44,0xc1,0xc3,0xed,0x43,0x96,0xa5,0x52,0x44,0x0,0x30,0xd2,0x43,0xe6,0xf1,0x54,0x44,0x8,0x0,0x0,0x0,0x3f,0x9c,0xb6,0x43,0x37,0x3e,0x57,0x44,0x34,0x3,0x75,0x43,0x9f,0x13,0x5d,0x44,0x34,0x3,0x75,0x43,0x9f,0x13,0x5d,0x44,0x4,0x0,0x0,0x0,0x9d,0xd4,0x71,0x42,0x63,0x9f,0x66,0x44,0x4,0x0,0x0,0x0,0x12,0x8,0x5e,0x42,0xc2,0x6,0x62,0x44,0x4,0x0,0x0,0x0,0x3a,0xe7,0xb5,0x43,0xd7,0xd2,0x52,0x44,0x8,0x0,0x0,0x0,0x3a,0xe7,0xb5,0x43,0xd7,0xd2,0x52,0x44,0xe5,0xae,0xe0,0x43,0xb0,0x2a,0x4d,0x44,0x21,0x2b,0xe9,0x43,0xf,0x96,0x51,0x44,0x8,0x0,0x0,0x0,0x5c,0xa7,0xf1,0x43,0x6f,0x1,0x56,0x44,0xed,0x20,0xf4,0x43,0xb9,0x98,0x57,0x44,0xf2,0xd5,0xf4,0x43,0x96,0xa9,0x5b,0x44,0x8,0x0,0x0,0x0,0xf7,0x8a,0xf5,0x43,0x72,0xba,0x5f,0x44,0x7a,0xe5,0xf5,0x43,0x5e,0xea,0x65,0x44,0x7a,0xe5,0xf5,0x43,0x5e,0xea,0x65,0x44,0x4,0x0,0x0,0x0,0x97,0xf,0x1a,0x44,0xf4,0x4b,0x32,0x44,0x4,0x0,0x0,0x0,0xf6,0x7a,0x1e,0x44,0x85,0xc5,0x34,0x44,0x4,0x0,0x0,0x0,0x1,0xf5,0xf6,0x43,0xdd,0x48,0x6f,0x44,0x4,0x0,0x0,0x0,0xfc,0x3f,0xf6,0x43,0xce,0x91,0x80,0x44,0x4,0x0,0x0,0x0,0x1c,0x76,0xe8,0x43,0x8c,0x64,0x80,0x44,0x1,0x0,0x0,0x0,0x6f,0x62,0x6a,0x33,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x97,0x2f,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0x14,0x14,0x14,0x0,0x21,0x2b,0xe9,0x43,0xc4,0xc3,0x74,0x44,0x21,0x2b,0xe9,0x43,0xc4,0xc3,0x74,0x44,0x1,0x3,0xc,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x21,0x2b,0xe9,0x43,0xc4,0xc3,0x74,0x44,0x6f,0x62,0x6a,0x35,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x97,0x2f,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0xa6,0x69,0x0,0x0,0x5d,0x9f,0xea,0x43,0xee,0x18,0x36,0x44,0x7e,0x6,0x1c,0x44,0x62,0x7f,0x81,0x44,0x1,0x3,0xc8,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x5d,0x9f,0xea,0x43,0xe0,0x24,0x81,0x44,0x4,0x0,0x0,0x0,0x67,0x9,0xec,0x43,0x15,0x8e,0x72,0x44,0x8,0x0,0x0,0x0,0x67,0x9,0xec,0x43,0x15,0x8e,0x72,0x44,0xe0,0xf9,0xea,0x43,0xfd,0x4,0x6f,0x44,0xa2,0x85,0xf4,0x43,0x8a,0xc5,0x67,0x44,0x8,0x0,0x0,0x0,0x65,0x11,0xfe,0x43,0x17,0x86,0x60,0x44,0x15,0x31,0x16,0x44,0xca,0x29,0x3a,0x44,0x15,0x31,0x16,0x44,0xca,0x29,0x3a,0x44,0x4,0x0,0x0,0x0,0x83,0xb7,0x13,0x44,0x2,0xed,0x38,0x44,0x4,0x0,0x0,0x0,0xf6,0xf6,0x1a,0x44,0xee,0x18,0x36,0x44,0x4,0x0,0x0,0x0,0x7e,0x6,0x1c,0x44,0x61,0x58,0x3d,0x44,0x4,0x0,0x0,0x0,0x6f,0xe7,0x19,0x44,0x57,0xee,0x3b,0x44,0x4,0x0,0x0,0x0,0xe8,0x6b,0xfe,0x43,0xcf,0xa7,0x68,0x44,0x8,0x0,0x0,0x0,0xe8,0x6b,0xfe,0x43,0xcf,0xa7,0x68,0x44,0xb1,0xa4,0xf6,0x43,0xf2,0x9a,0x6d,0x44,0xb1,0xa4,0xf6,0x43,0x84,0x14,0x70,0x44,0x8,0x0,0x0,0x0,0xb1,0xa4,0xf6,0x43,0x15,0x8e,0x72,0x44,0xb1,0xa4,0xf6,0x43,0x62,0x7f,0x81,0x44,0xb1,0xa4,0xf6,0x43,0x62,0x7f,0x81,0x44,0x1,0x0,0x0,0x0,0x6f,0x62,0x6a,0x35,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x97,0x2f,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0xa6,0x69,0x0,0x0,0x5d,0x9f,0xea,0x43,0xe0,0x24,0x81,0x44,0x5d,0x9f,0xea,0x43,0xe0,0x24,0x81,0x44,0x1,0x3,0xc,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x5d,0x9f,0xea,0x43,0xe0,0x24,0x81,0x44};


unsigned char vgModel_01[] = {0x1,0x0,0xef,0xbe,0x7,0x0,0x0,0x0,0x20,0x3,0x0,0x0,0xdc,0x0,0x0,0x0,0x2c,0x0,0x0,0x0,0x83,0x1,0x0,0x0,0x9e,0x2,0x0,0x0,0xf5,0x2,0x0,0x0,0xb0,0x3,0x0,0x0,0x7,0x4,0x0,0x0,0x1a,0x5,0x0,0x0,0x6f,0x62,0x6a,0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0xc8,0xc8,0xc8,0x0,0x0,0x0,0xe0,0xc0,0x2e,0x6d,0x5b,0x44,0x1,0xd0,0x49,0x44,0x97,0xf5,0x85,0x44,0x1,0x3,0xc,0x1,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0xe0,0xc0,0x2e,0x6d,0x5b,0x44,0x4,0x0,0x0,0x0,0x0,0x0,0xd9,0xc0,0x2e,0x99,0x5d,0x44,0x4,0x0,0x0,0x0,0x0,0x0,0xc3,0xc0,0x2e,0x7d,0x64,0x44,0x4,0x0,0x0,0x0,0x0,0x0,0xbd,0xc0,0x2e,0x1f,0x66,0x44,0x4,0x0,0x0,0x0,0x0,0x0,0x18,0x3f,0x2e,0x4f,0x66,0x44,0x4,0x0,0x0,0x0,0x0,0xc8,0xc0,0x43,0x2e,0x13,0x71,0x44,0x4,0x0,0x0,0x0,0x0,0x20,0xc0,0x43,0x97,0xae,0x84,0x44,0x4,0x0,0x0,0x0,0x2,0x14,0xc0,0x43,0x97,0x92,0x85,0x44,0x4,0x0,0x0,0x0,0x2,0xa0,0xc3,0x43,0x97,0xa1,0x85,0x44,0x4,0x0,0x0,0x0,0x2,0xe4,0xd3,0x43,0x97,0xe5,0x85,0x44,0x4,0x0,0x0,0x0,0x2,0xcc,0xd7,0x43,0x97,0xf5,0x85,0x44,0x4,0x0,0x0,0x0,0x2,0xe0,0xd7,0x43,0x97,0xfa,0x84,0x44,0x4,0x0,0x0,0x0,0x2,0xe0,0xd8,0x43,0x2e,0x4d,0x71,0x44,0x4,0x0,0x0,0x0,0x1,0x18,0x48,0x44,0x2e,0x51,0x69,0x44,0x4,0x0,0x0,0x0,0x1,0xd0,0x49,0x44,0x2e,0x2b,0x69,0x44,0x4,0x0,0x0,0x0,0x1,0xd0,0x49,0x44,0x2e,0x73,0x67,0x44,0x4,0x0,0x0,0x0,0x1,0xd0,0x49,0x44,0x2e,0x43,0x61,0x44,0x4,0x0,0x0,0x0,0x1,0xd0,0x49,0x44,0x2e,0x33,0x5f,0x44,0x4,0x0,0x0,0x0,0x1,0xc2,0x47,0x44,0x2e,0x65,0x5f,0x44,0x4,0x0,0x0,0x0,0x2,0x54,0xd2,0x43,0x2e,0x37,0x68,0x44,0x4,0x0,0x0,0x0,0x0,0x0,0xcc,0x3f,0x2e,0xaf,0x5b,0x44,0x4,0x0,0x0,0x0,0x0,0x0,0xe0,0xc0,0x2e,0x6d,0x5b,0x44,0x1,0x0,0x0,0x0,0x6f,0x62,0x6a,0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0xc8,0xc8,0xc8,0x0,0x0,0x0,0x7,0x41,0x2e,0xab,0x5f,0x44,0x0,0x10,0x46,0x44,0x96,0xf6,0x83,0x44,0x1,0x3,0xd0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0xe0,0xc0,0x2e,0x6d,0x5b,0x44,0x2,0x0,0x0,0x0,0x0,0x0,0x7,0x41,0x2e,0xab,0x5f,0x44,0x4,0x0,0x0,0x0,0x0,0xdc,0xd1,0x43,0x2e,0xf5,0x6b,0x44,0x4,0x0,0x0,0x0,0x0,0x40,0xd2,0x43,0x2d,0xfb,0x6b,0x44,0x4,0x0,0x0,0x0,0x0,0xa8,0xd2,0x43,0x2d,0xf7,0x6b,0x44,0x4,0x0,0x0,0x0,0x0,0x10,0x46,0x44,0x2d,0x51,0x63,0x44,0x4,0x0,0x0,0x0,0x0,0x10,0x46,0x44,0x2d,0xbb,0x65,0x44,0x4,0x0,0x0,0x0,0x0,0xe0,0xd4,0x43,0x2d,0xb5,0x6d,0x44,0x4,0x0,0x0,0x0,0x0,0x84,0xd1,0x43,0x2d,0xdb,0x6d,0x44,0x4,0x0,0x0,0x0,0x0,0x70,0xd1,0x43,0x2d,0x8b,0x6f,0x44,0x4,0x0,0x0,0x0,0x0,0x74,0xd0,0x43,0x96,0xf6,0x83,0x44,0x4,0x0,0x0,0x0,0x0,0xac,0xc7,0x43,0x97,0xd1,0x83,0x44,0x4,0x0,0x0,0x0,0x0,0x54,0xc8,0x43,0x2d,0x6d,0x6f,0x44,0x4,0x0,0x0,0x0,0xfe,0x5f,0xc8,0x43,0x2d,0xbb,0x6d,0x44,0x4,0x0,0x0,0x0,0x0,0x0,0xc5,0x43,0x2e,0x89,0x6d,0x44,0x4,0x0,0x0,0x0,0x0,0x0,0xc,0x41,0x2e,0xc3,0x62,0x44,0x4,0x0,0x0,0x0,0x0,0x0,0x7,0x41,0x2e,0xab,0x5f,0x44,0x1,0x0,0x0,0x0,0x6f,0x62,0x6a,0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0xc8,0xc8,0xc8,0x0,0x0,0x0,0x7,0x41,0x2e,0xab,0x5f,0x44,0x0,0x0,0x7,0x41,0x2e,0xab,0x5f,0x44,0x1,0x3,0xc,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x7,0x41,0x2e,0xab,0x5f,0x44,0x6f,0x62,0x6a,0x33,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0x14,0x14,0x14,0x0,0x20,0x14,0x54,0x3f,0xed,0x9a,0x5d,0x44,0xfb,0xf6,0x47,0x44,0xf2,0xfc,0x84,0x44,0x1,0x3,0x70,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0xe3,0xed,0xc3,0x43,0x11,0xb9,0x84,0x44,0x4,0x0,0x0,0x0,0xe8,0xa2,0xc4,0x43,0xaa,0x75,0x6f,0x44,0x4,0x0,0x0,0x0,0x51,0x8c,0xc4,0x3f,0xde,0x7f,0x64,0x44,0x4,0x0,0x0,0x0,0x20,0x14,0x54,0x3f,0xed,0x9a,0x5d,0x44,0x4,0x0,0x0,0x0,0x40,0x5d,0xd2,0x43,0x5,0x28,0x6a,0x44,0x4,0x0,0x0,0x0,0xfb,0xf6,0x47,0x44,0x47,0x51,0x61,0x44,0x4,0x0,0x0,0x0,0xfb,0xf6,0x47,0x44,0x33,0x81,0x67,0x44,0x4,0x0,0x0,0x0,0xdc,0x40,0xd5,0x43,0xeb,0xa2,0x6f,0x44,0x4,0x0,0x0,0x0,0x54,0x31,0xd4,0x43,0xf2,0xfc,0x84,0x44,0x1,0x0,0x0,0x0,0x6f,0x62,0x6a,0x33,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0x14,0x14,0x14,0x0,0xe3,0xed,0xc3,0x43,0x11,0xb9,0x84,0x44,0xe3,0xed,0xc3,0x43,0x11,0xb9,0x84,0x44,0x1,0x3,0xc,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0xe3,0xed,0xc3,0x43,0x11,0xb9,0x84,0x44,0x6f,0x62,0x6a,0x35,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0xa6,0x69,0x0,0x0,0x65,0x48,0xc5,0x43,0xdc,0x5,0x60,0x44,0x4d,0xbb,0x38,0x44,0xec,0x8c,0x86,0x44,0x1,0x3,0xc8,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x65,0x48,0xc5,0x43,0x6a,0x32,0x86,0x44,0x4,0x0,0x0,0x0,0xf2,0xc,0xc7,0x43,0x90,0x76,0x70,0x44,0x8,0x0,0x0,0x0,0xf2,0xc,0xc7,0x43,0x90,0x76,0x70,0x44,0x83,0x86,0xc9,0x43,0x2c,0x56,0x6b,0x44,0xc8,0x6c,0xd3,0x43,0x68,0xce,0x6a,0x44,0x8,0x0,0x0,0x0,0xe,0x53,0xdd,0x43,0xa4,0x46,0x6a,0x44,0x5d,0xd6,0x31,0x44,0xf5,0x8e,0x63,0x44,0x5d,0xd6,0x31,0x44,0xf5,0x8e,0x63,0x44,0x4,0x0,0x0,0x0,0x99,0x4e,0x31,0x44,0xdc,0x5,0x60,0x44,0x4,0x0,0x0,0x0,0x4d,0xbb,0x38,0x44,0x45,0xdb,0x65,0x44,0x4,0x0,0x0,0x0,0xe4,0xe5,0x32,0x44,0xf4,0x92,0x6c,0x44,0x4,0x0,0x0,0x0,0xdf,0x30,0x32,0x44,0x18,0x82,0x68,0x44,0x4,0x0,0x0,0x0,0x95,0x62,0xde,0x43,0x86,0xc,0x6f,0x44,0x8,0x0,0x0,0x0,0x95,0x62,0xde,0x43,0x86,0xc,0x6f,0x44,0x40,0x5d,0xd2,0x43,0xf4,0x92,0x6c,0x44,0xc3,0xb7,0xd2,0x43,0x48,0x98,0x78,0x44,0x8,0x0,0x0,0x0,0x46,0x12,0xd3,0x43,0xce,0x4e,0x82,0x44,0x40,0x5d,0xd2,0x43,0xec,0x8c,0x86,0x44,0x40,0x5d,0xd2,0x43,0xec,0x8c,0x86,0x44,0x1,0x0,0x0,0x0,0x6f,0x62,0x6a,0x35,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0xa6,0x69,0x0,0x0,0x65,0x48,0xc5,0x43,0x6a,0x32,0x86,0x44,0x65,0x48,0xc5,0x43,0x6a,0x32,0x86,0x44,0x1,0x3,0xc,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x65,0x48,0xc5,0x43,0x6a,0x32,0x86,0x44};


unsigned char vgModel_02[] = {0x1,0x0,0xef,0xbe,0x7,0x0,0x0,0x0,0x20,0x3,0x0,0x0,0xdc,0x0,0x0,0x0,0x2c,0x0,0x0,0x0,0xd7,0x1,0x0,0x0,0x2e,0x3,0x0,0x0,0x85,0x3,0x0,0x0,0x64,0x4,0x0,0x0,0xbb,0x4,0x0,0x0,0xce,0x5,0x0,0x0,0x6f,0x62,0x6a,0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0xc8,0xc8,0xc8,0x0,0x34,0x80,0x1e,0xc1,0x2e,0xe5,0x4b,0x44,0xff,0xb5,0x1e,0x44,0x97,0xbc,0x86,0x44,0x1,0x3,0x60,0x1,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0xd4,0xd6,0x43,0x2e,0xe5,0x4b,0x44,0x4,0x0,0x0,0x0,0x0,0xfc,0xd2,0x43,0x2e,0xf1,0x4b,0x44,0x4,0x0,0x0,0x0,0x0,0x70,0xc3,0x43,0x2e,0x1d,0x4c,0x44,0x4,0x0,0x0,0x0,0x0,0xc0,0xbf,0x43,0x2e,0x29,0x4c,0x44,0x4,0x0,0x0,0x0,0xfe,0xc3,0xbf,0x43,0x2e,0x1,0x4e,0x44,0x4,0x0,0x0,0x0,0xfe,0x17,0xc0,0x43,0x2e,0xab,0x69,0x44,0x4,0x0,0x0,0x0,0xcc,0x7f,0x1,0x41,0x2e,0x3d,0x53,0x44,0x4,0x0,0x0,0x0,0xb9,0xfc,0x77,0x3f,0x2e,0xd1,0x52,0x44,0x4,0x0,0x0,0x0,0x47,0x3,0x60,0xbf,0x2e,0x95,0x54,0x44,0x4,0x0,0x0,0x0,0x69,0x0,0xff,0xc0,0x2e,0x4d,0x5b,0x44,0x4,0x0,0x0,0x0,0x34,0x80,0x1e,0xc1,0x2e,0x29,0x5d,0x44,0x4,0x0,0x0,0x0,0xd2,0x0,0x1c,0xc0,0x2e,0x9b,0x5d,0x44,0x4,0x0,0x0,0x0,0xfe,0x1b,0xc0,0x43,0x2e,0x6b,0x74,0x44,0x4,0x0,0x0,0x0,0xfe,0xc3,0xbf,0x43,0x97,0xbf,0x85,0x44,0x4,0x0,0x0,0x0,0xfe,0xbb,0xbf,0x43,0x97,0xbc,0x86,0x44,0x4,0x0,0x0,0x0,0xfe,0xaf,0xc3,0x43,0x97,0xb0,0x86,0x44,0x4,0x0,0x0,0x0,0xfe,0xe3,0xd2,0x43,0x97,0x83,0x86,0x44,0x4,0x0,0x0,0x0,0xfe,0x5b,0xd6,0x43,0x97,0x79,0x86,0x44,0x4,0x0,0x0,0x0,0xfe,0x77,0xd6,0x43,0x97,0x9b,0x85,0x44,0x4,0x0,0x0,0x0,0xfe,0xcf,0xd7,0x43,0x2e,0x8b,0x74,0x44,0x4,0x0,0x0,0x0,0xff,0xe1,0x1c,0x44,0x2e,0x5,0x57,0x44,0x4,0x0,0x0,0x0,0xff,0xb5,0x1e,0x44,0x2e,0xeb,0x55,0x44,0x4,0x0,0x0,0x0,0xff,0x61,0x1d,0x44,0x2e,0x41,0x54,0x44,0x4,0x0,0x0,0x0,0xff,0x51,0x19,0x44,0x2e,0x1f,0x4f,0x44,0x4,0x0,0x0,0x0,0xff,0x4f,0x18,0x44,0x2e,0xd9,0x4d,0x44,0x4,0x0,0x0,0x0,0xff,0xe7,0x16,0x44,0x2e,0xab,0x4e,0x44,0x4,0x0,0x0,0x0,0xfe,0xd3,0xd6,0x43,0x2e,0x11,0x68,0x44,0x4,0x0,0x0,0x0,0xfe,0xd3,0xd6,0x43,0x2e,0xd1,0x4d,0x44,0x4,0x0,0x0,0x0,0xfe,0xd3,0xd6,0x43,0x2e,0xe5,0x4b,0x44,0x1,0x0,0x0,0x0,0x6f,0x62,0x6a,0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0xc8,0xc8,0xc8,0x0,0x0,0x0,0x8,0x41,0x2e,0xbb,0x4f,0x44,0x0,0x1e,0x19,0x44,0x97,0xc5,0x84,0x44,0x1,0x3,0xc,0x1,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0xd4,0xd6,0x43,0x2e,0xe5,0x4b,0x44,0x2,0x0,0x0,0x0,0x0,0x54,0xcf,0x43,0x2e,0xbb,0x4f,0x44,0x4,0x0,0x0,0x0,0x0,0x54,0xcf,0x43,0x2e,0x55,0x6b,0x44,0x4,0x0,0x0,0x0,0x0,0x54,0xcf,0x43,0x2e,0x9b,0x6e,0x44,0x4,0x0,0x0,0x0,0x0,0xf8,0xd4,0x43,0x2e,0xf5,0x6c,0x44,0x4,0x0,0x0,0x0,0x0,0x64,0x17,0x44,0x2e,0xbb,0x52,0x44,0x4,0x0,0x0,0x0,0x0,0x1e,0x19,0x44,0x2e,0xe9,0x54,0x44,0x4,0x0,0x0,0x0,0x0,0x34,0xd2,0x43,0x2e,0xdd,0x71,0x44,0x4,0x0,0x0,0x0,0x0,0x70,0xd0,0x43,0x2e,0x63,0x72,0x44,0x4,0x0,0x0,0x0,0x2,0x64,0xd0,0x43,0x2e,0x69,0x73,0x44,0x4,0x0,0x0,0x0,0x2,0x14,0xcf,0x43,0x97,0xae,0x84,0x44,0x4,0x0,0x0,0x0,0x2,0x4c,0xc7,0x43,0x97,0xc5,0x84,0x44,0x4,0x0,0x0,0x0,0x2,0xa0,0xc7,0x43,0x2e,0xf3,0x72,0x44,0x4,0x0,0x0,0x0,0x0,0xa4,0xc7,0x43,0x2e,0x75,0x71,0x44,0x4,0x0,0x0,0x0,0x0,0xbc,0xc4,0x43,0x2e,0x1d,0x71,0x44,0x4,0x0,0x0,0x0,0x0,0x0,0x8,0x41,0x2e,0x65,0x5a,0x44,0x4,0x0,0x0,0x0,0x0,0x0,0x3c,0x41,0x2e,0x4f,0x57,0x44,0x4,0x0,0x0,0x0,0x0,0x0,0xc3,0x43,0x2e,0xdd,0x6d,0x44,0x4,0x0,0x0,0x0,0x0,0xa4,0xc7,0x43,0x2e,0x6b,0x6e,0x44,0x4,0x0,0x0,0x0,0x2,0xa0,0xc7,0x43,0x2e,0x9,0x6c,0x44,0x4,0x0,0x0,0x0,0x2,0x48,0xc7,0x43,0x2e,0xd3,0x4f,0x44,0x4,0x0,0x0,0x0,0x2,0x54,0xcf,0x43,0x2e,0xbb,0x4f,0x44,0x1,0x0,0x0,0x0,0x6f,0x62,0x6a,0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0xc8,0xc8,0xc8,0x0,0x0,0x54,0xcf,0x43,0x2e,0xbb,0x4f,0x44,0x0,0x54,0xcf,0x43,0x2e,0xbb,0x4f,0x44,0x1,0x3,0xc,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x54,0xcf,0x43,0x2e,0xbb,0x4f,0x44,0x6f,0x62,0x6a,0x33,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0x14,0x14,0x14,0x0,0xdf,0xc3,0x87,0xbf,0x3e,0xe7,0x4d,0x44,0x23,0xd4,0x1b,0x44,0x97,0xcc,0x85,0x44,0x1,0x3,0x94,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x98,0x56,0xc3,0x43,0x97,0xcc,0x85,0x44,0x4,0x0,0x0,0x0,0x1a,0xb1,0xc3,0x43,0xc1,0x6,0x73,0x44,0x4,0x0,0x0,0x0,0xdf,0xc3,0x87,0xbf,0x60,0xde,0x5b,0x44,0x4,0x0,0x0,0x0,0x3d,0x55,0xc0,0x40,0xb1,0x26,0x55,0x44,0x4,0x0,0x0,0x0,0x1a,0xb1,0xc3,0x43,0xd1,0x21,0x6c,0x44,0x4,0x0,0x0,0x0,0x98,0x56,0xc3,0x43,0x7f,0x14,0x4e,0x44,0x4,0x0,0x0,0x0,0x5,0xe5,0xd2,0x43,0x3e,0xe7,0x4d,0x44,0x4,0x0,0x0,0x0,0x5,0xe5,0xd2,0x43,0xcd,0x6c,0x6b,0x44,0x4,0x0,0x0,0x0,0x46,0xc3,0x17,0x44,0xcf,0x60,0x50,0x44,0x4,0x0,0x0,0x0,0x23,0xd4,0x1b,0x44,0x33,0x81,0x55,0x44,0x4,0x0,0x0,0x0,0x8c,0xf4,0xd3,0x43,0x84,0x8e,0x73,0x44,0x4,0x0,0x0,0x0,0x82,0x8a,0xd2,0x43,0x56,0x9f,0x85,0x44,0x1,0x0,0x0,0x0,0x6f,0x62,0x6a,0x33,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0x14,0x14,0x14,0x0,0x98,0x56,0xc3,0x43,0x97,0xcc,0x85,0x44,0x98,0x56,0xc3,0x43,0x97,0xcc,0x85,0x44,0x1,0x3,0xc,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x98,0x56,0xc3,0x43,0x97,0xcc,0x85,0x44,0x6f,0x62,0x6a,0x35,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0xa6,0x69,0x0,0x0,0x2d,0xbc,0x18,0x42,0x15,0xc5,0x55,0x44,0x45,0x12,0xd3,0x43,0x32,0x6f,0x87,0x44,0x1,0x3,0xc8,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x5b,0xde,0xc3,0x43,0x32,0x6f,0x87,0x44,0x4,0x0,0x0,0x0,0x65,0x48,0xc5,0x43,0xf8,0x4b,0x76,0x44,0x8,0x0,0x0,0x0,0x65,0x48,0xc5,0x43,0xf8,0x4b,0x76,0x44,0x87,0x3b,0xca,0x43,0x5e,0x68,0x72,0x44,0x98,0x52,0xba,0x43,0x53,0xfe,0x70,0x44,0x8,0x0,0x0,0x0,0xa9,0x69,0xaa,0x43,0x4a,0x94,0x6f,0x44,0xa6,0x3e,0x73,0x42,0x55,0xf6,0x5e,0x44,0xa6,0x3e,0x73,0x42,0x55,0xf6,0x5e,0x44,0x4,0x0,0x0,0x0,0x43,0x1a,0x65,0x42,0x6e,0x7f,0x62,0x44,0x4,0x0,0x0,0x0,0x2d,0xbc,0x18,0x42,0x79,0xe5,0x5a,0x44,0x4,0x0,0x0,0x0,0xd4,0x1,0x8c,0x42,0x15,0xc5,0x55,0x44,0x4,0x0,0x0,0x0,0x98,0x85,0x83,0x42,0x33,0x3,0x5a,0x44,0x4,0x0,0x0,0x0,0x87,0x3b,0xca,0x43,0xfe,0xfc,0x6d,0x44,0x8,0x0,0x0,0x0,0x87,0x3b,0xca,0x43,0xfe,0xfc,0x6d,0x44,0x45,0x12,0xd3,0x43,0x44,0xdf,0x6e,0x44,0xc3,0xb7,0xd2,0x43,0x7,0x6b,0x78,0x44,0x8,0x0,0x0,0x0,0x40,0x5d,0xd2,0x43,0x65,0xfb,0x80,0x44,0x3b,0xa8,0xd1,0x43,0x92,0x58,0x87,0x44,0x3b,0xa8,0xd1,0x43,0x92,0x58,0x87,0x44,0x1,0x0,0x0,0x0,0x6f,0x62,0x6a,0x35,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0xa6,0x69,0x0,0x0,0x5b,0xde,0xc3,0x43,0x32,0x6f,0x87,0x44,0x5b,0xde,0xc3,0x43,0x32,0x6f,0x87,0x44,0x1,0x3,0xc,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x5b,0xde,0xc3,0x43,0x32,0x6f,0x87,0x44};

unsigned char vgModel_03[] = {0x1,0x0,0xef,0xbe,0x7,0x0,0x0,0x0,0x20,0x3,0x0,0x0,0xdc,0x0,0x0,0x0,0x2c,0x0,0x0,0x0,0x67,0x3,0x0,0x0,0x22,0x6,0x0,0x0,0x79,0x6,0x0,0x0,0xf4,0x7,0x0,0x0,0x4b,0x8,0x0,0x0,0xea,0x9,0x0,0x0,0x6f,0x62,0x6a,0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0xc8,0xc8,0xc8,0x0,0x3e,0x38,0x65,0xc0,0x0,0x2a,0x44,0x44,0xc9,0x54,0x33,0x44,0x0,0x29,0x88,0x44,0x1,0x3,0xf0,0x2,0x0,0x0,0x2,0x0,0x0,0x0,0xc8,0xaa,0x2b,0x44,0x0,0x2a,0x44,0x44,0x4,0x0,0x0,0x0,0xc8,0x48,0x2a,0x44,0x0,0x4a,0x45,0x44,0x4,0x0,0x0,0x0,0xc8,0x64,0x3,0x44,0x0,0x1c,0x65,0x44,0x8,0x0,0x0,0x0,0xc8,0x64,0x3,0x44,0x0,0x1c,0x65,0x44,0xb5,0xd1,0xfd,0x43,0xe9,0xbf,0x68,0x44,0x8f,0x9,0xf4,0x43,0x0,0xfa,0x6a,0x44,0x8,0x0,0x0,0x0,0x7d,0x25,0xef,0x43,0xc,0x17,0x6c,0x44,0x43,0x1a,0xea,0x43,0x73,0xcb,0x6c,0x44,0x8f,0x5d,0xe6,0x43,0x0,0xac,0x6c,0x44,0x8,0x0,0x0,0x0,0xdc,0xa0,0xe2,0x43,0x8e,0x8c,0x6c,0x44,0xd0,0x39,0xe0,0x43,0x4c,0xf4,0x6b,0x44,0x8f,0x4d,0xde,0x43,0x0,0xb6,0x69,0x44,0x8,0x0,0x0,0x0,0xc7,0xda,0xd8,0x43,0xc1,0x5a,0x63,0x44,0xa0,0x8c,0xcc,0x43,0x64,0x51,0x61,0x44,0x8f,0x81,0xc2,0x43,0x0,0xf6,0x60,0x44,0x8,0x0,0x0,0x0,0x7f,0x76,0xb8,0x43,0x9d,0x9a,0x60,0x44,0x8f,0xd5,0xaf,0x43,0x0,0xbe,0x61,0x44,0x8f,0xd5,0xaf,0x43,0x0,0xbe,0x61,0x44,0x4,0x0,0x0,0x0,0x8f,0xa9,0xaf,0x43,0x0,0xc4,0x61,0x44,0x4,0x0,0x0,0x0,0x8f,0x81,0xaf,0x43,0x0,0xcc,0x61,0x44,0x4,0x0,0x0,0x0,0x1f,0xc3,0x33,0x43,0x0,0x50,0x71,0x44,0x4,0x0,0x0,0x0,0x3e,0xb6,0xcd,0x42,0x0,0x8,0x4b,0x44,0x4,0x0,0x0,0x0,0x3e,0x26,0xc7,0x42,0x0,0x64,0x49,0x44,0x4,0x0,0x0,0x0,0x3e,0xe6,0xb9,0x42,0x0,0x2c,0x4a,0x44,0x4,0x0,0x0,0x0,0x3e,0x6,0x87,0x42,0x0,0x2e,0x4d,0x44,0x4,0x0,0x0,0x0,0x7c,0x8c,0x72,0x42,0x0,0xfe,0x4d,0x44,0x4,0x0,0x0,0x0,0x7c,0xec,0x7f,0x42,0x0,0xb4,0x4f,0x44,0x4,0x0,0x0,0x0,0x1f,0xcb,0xb,0x43,0x0,0x72,0x76,0x44,0x4,0x0,0x0,0x0,0xc2,0xc7,0x50,0x40,0x0,0xf5,0x82,0x44,0x4,0x0,0x0,0x0,0x3e,0x38,0x65,0xc0,0x0,0x58,0x83,0x44,0x4,0x0,0x0,0x0,0xf1,0xc1,0xe9,0xbe,0x0,0x33,0x84,0x44,0x4,0x0,0x0,0x0,0xf0,0xb1,0x2d,0x41,0x0,0x4b,0x87,0x44,0x4,0x0,0x0,0x0,0xf0,0x31,0x60,0x41,0x0,0x29,0x88,0x44,0x4,0x0,0x0,0x0,0xf8,0x18,0xa7,0x41,0x0,0xc0,0x87,0x44,0x8,0x0,0x0,0x0,0xf8,0x18,0xa7,0x41,0x0,0xc0,0x87,0x44,0xd7,0xcf,0xb1,0x42,0xda,0xb5,0x83,0x44,0x1f,0xbb,0x24,0x43,0x0,0xf8,0x7e,0x44,0x8,0x0,0x0,0x0,0xb8,0xa4,0x4a,0x43,0x25,0xbe,0x7a,0x44,0xee,0x80,0x72,0x43,0xde,0x6c,0x76,0x44,0x8f,0x5d,0x8a,0x43,0x0,0xfc,0x72,0x44,0x8,0x0,0x0,0x0,0xa8,0x7a,0x9b,0x43,0x22,0x8b,0x6f,0x44,0x35,0xfe,0xa9,0x43,0x86,0xfa,0x6c,0x44,0x8f,0x21,0xb1,0x43,0x0,0x4c,0x6c,0x44,0x8,0x0,0x0,0x0,0xd5,0xd7,0xbf,0x43,0x4c,0xe4,0x6a,0x44,0x3,0xa3,0xc6,0x43,0x7d,0x24,0x6d,0x44,0x8f,0xa1,0xca,0x43,0x0,0xa0,0x6f,0x44,0x8,0x0,0x0,0x0,0x85,0x8d,0xce,0x43,0xf4,0xf,0x72,0x44,0xb1,0x4a,0xcf,0x43,0x7f,0xc4,0x74,0x44,0x8f,0x51,0xcf,0x43,0x0,0xde,0x74,0x44,0x4,0x0,0x0,0x0,0x8f,0x51,0xcf,0x43,0x0,0x5,0x86,0x44,0x4,0x0,0x0,0x0,0x8f,0x51,0xcf,0x43,0x0,0xe9,0x86,0x44,0x4,0x0,0x0,0x0,0x8f,0xe1,0xd2,0x43,0x0,0xf5,0x86,0x44,0x4,0x0,0x0,0x0,0x8f,0xa9,0xe0,0x43,0x0,0x22,0x87,0x44,0x4,0x0,0x0,0x0,0x8f,0xb5,0xe4,0x43,0x0,0x2f,0x87,0x44,0x4,0x0,0x0,0x0,0x8f,0x9d,0xe4,0x43,0x0,0x2c,0x86,0x44,0x8,0x0,0x0,0x0,0x8f,0x9d,0xe4,0x43,0x0,0x2c,0x86,0x44,0xa0,0x41,0xe4,0x43,0x99,0xcf,0x82,0x44,0x91,0x99,0xe4,0x43,0x0,0xaa,0x80,0x44,0x8,0x0,0x0,0x0,0x4f,0xb0,0xe4,0x43,0xe0,0x1b,0x80,0x44,0x80,0xbb,0xe7,0x43,0x12,0x47,0x7e,0x44,0x91,0x6d,0xeb,0x43,0x1,0xd6,0x7c,0x44,0x8,0x0,0x0,0x0,0xa3,0x1f,0xef,0x43,0xee,0x64,0x7b,0x44,0x91,0xd5,0xf2,0x43,0x0,0x70,0x7a,0x44,0x91,0xd5,0xf2,0x43,0x0,0x70,0x7a,0x44,0x4,0x0,0x0,0x0,0x91,0x29,0xf3,0x43,0x0,0x5c,0x7a,0x44,0x4,0x0,0x0,0x0,0x91,0x71,0xf3,0x43,0xff,0x3d,0x7a,0x44,0x4,0x0,0x0,0x0,0xc9,0xc2,0x31,0x44,0x0,0xde,0x4d,0x44,0x4,0x0,0x0,0x0,0xc9,0x54,0x33,0x44,0x0,0xa0,0x4c,0x44,0x4,0x0,0x0,0x0,0xc9,0xfc,0x31,0x44,0x0,0x24,0x4b,0x44,0x4,0x0,0x0,0x0,0xc9,0xdc,0x2c,0x44,0x0,0x7c,0x45,0x44,0x4,0x0,0x0,0x0,0xc9,0xaa,0x2b,0x44,0x0,0x2a,0x44,0x44,0x1,0x0,0x0,0x0,0x6f,0x62,0x6a,0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0xc8,0xc8,0xc8,0x0,0xf8,0x98,0x82,0x41,0x0,0x52,0x49,0x44,0xc8,0xdc,0x2d,0x44,0x0,0xa7,0x85,0x44,0x1,0x3,0x70,0x2,0x0,0x0,0x2,0x0,0x0,0x0,0xc8,0xaa,0x2b,0x44,0x0,0x2a,0x44,0x44,0x2,0x0,0x0,0x0,0xc8,0x48,0x2b,0x44,0x0,0x52,0x49,0x44,0x4,0x0,0x0,0x0,0xc8,0xdc,0x2d,0x44,0x0,0x2c,0x4c,0x44,0x4,0x0,0x0,0x0,0x8f,0x15,0xef,0x43,0x0,0x32,0x77,0x44,0x8,0x0,0x0,0x0,0x67,0x9b,0xee,0x43,0x97,0x51,0x77,0x44,0xf3,0xe5,0xea,0x43,0x93,0x48,0x78,0x44,0x8f,0xd1,0xe6,0x43,0x0,0xe0,0x79,0x44,0x8,0x0,0x0,0x0,0x89,0x78,0xe2,0x43,0x35,0x92,0x7b,0x44,0x54,0x61,0xdd,0x43,0xe1,0xde,0x7d,0x44,0x8f,0x1d,0xdd,0x43,0x0,0x97,0x80,0x44,0x8,0x0,0x0,0x0,0x71,0xd8,0xdc,0x43,0xfe,0x46,0x82,0x44,0xd6,0xf3,0xdc,0x43,0x4d,0x25,0x84,0x44,0x8f,0x9,0xdd,0x43,0x0,0x36,0x85,0x44,0x4,0x0,0x0,0x0,0x8f,0xd1,0xd6,0x43,0x0,0x21,0x85,0x44,0x4,0x0,0x0,0x0,0x8f,0xd1,0xd6,0x43,0x0,0xb4,0x74,0x44,0x4,0x0,0x0,0x0,0x8f,0xd1,0xd6,0x43,0x0,0x98,0x74,0x44,0x4,0x0,0x0,0x0,0x8f,0xc9,0xd6,0x43,0x0,0x7c,0x74,0x44,0x8,0x0,0x0,0x0,0x8f,0xc9,0xd6,0x43,0x0,0x7c,0x74,0x44,0x25,0xf0,0xd5,0x43,0x37,0xab,0x70,0x44,0x8f,0x79,0xd0,0x43,0x0,0x46,0x6d,0x44,0x8,0x0,0x0,0x0,0xfa,0x2,0xcb,0x43,0xca,0xe0,0x69,0x44,0xa6,0x7a,0xc0,0x43,0x5f,0x2,0x67,0x44,0x8f,0xb9,0xaf,0x43,0x0,0x9c,0x68,0x44,0x8,0x0,0x0,0x0,0x3c,0x21,0xa7,0x43,0x25,0x6e,0x69,0x44,0xb3,0xd3,0x98,0x43,0xb0,0x9,0x6c,0x44,0x8f,0x91,0x87,0x43,0x0,0x82,0x6f,0x44,0x8,0x0,0x0,0x0,0xd7,0x9e,0x6c,0x43,0x51,0xfa,0x72,0x44,0x79,0x9e,0x44,0x43,0x48,0x4f,0x77,0x44,0x1f,0x9b,0x1e,0x43,0x0,0x8c,0x7b,0x44,0x8,0x0,0x0,0x0,0x18,0x38,0xb1,0x42,0xb1,0xac,0x81,0x44,0x55,0xa6,0xf7,0x41,0x64,0x15,0x85,0x44,0xf8,0xd8,0xaa,0x41,0x0,0xa7,0x85,0x44,0x4,0x0,0x0,0x0,0xf8,0x98,0x82,0x41,0x0,0x46,0x84,0x44,0x4,0x0,0x0,0x0,0x1f,0x3,0x19,0x43,0x0,0x10,0x79,0x44,0x4,0x0,0x0,0x0,0x1f,0xb,0x20,0x43,0x0,0x44,0x78,0x44,0x4,0x0,0x0,0x0,0x1f,0xa3,0x1c,0x43,0x0,0x88,0x76,0x44,0x4,0x0,0x0,0x0,0x3e,0x96,0xa1,0x42,0x0,0xc2,0x4f,0x44,0x4,0x0,0x0,0x0,0x3e,0x76,0xb9,0x42,0x0,0x58,0x4e,0x44,0x4,0x0,0x0,0x0,0x1f,0x5b,0x29,0x43,0x0,0x7c,0x74,0x44,0x4,0x0,0x0,0x0,0x1f,0x5b,0x2c,0x43,0x0,0xfa,0x75,0x44,0x4,0x0,0x0,0x0,0x1f,0xa3,0x32,0x43,0x0,0x68,0x75,0x44,0x4,0x0,0x0,0x0,0x8f,0xb9,0xb1,0x43,0x0,0x60,0x65,0x44,0x8,0x0,0x0,0x0,0x8f,0xb9,0xb1,0x43,0x0,0x60,0x65,0x44,0x77,0xc5,0xb1,0x43,0x3,0x5e,0x65,0x44,0x8e,0xc5,0xb1,0x43,0x1,0x5e,0x65,0x44,0x8,0x0,0x0,0x0,0xa8,0xd8,0xb1,0x43,0x91,0x5b,0x65,0x44,0x13,0x69,0xb9,0x43,0x13,0x66,0x64,0x44,0x8e,0xf9,0xc1,0x43,0x1,0xb4,0x64,0x44,0x8,0x0,0x0,0x0,0xe0,0x94,0xca,0x43,0x52,0x2,0x65,0x44,0x93,0x4c,0xd3,0x43,0x32,0x68,0x66,0x44,0x8e,0x65,0xd7,0x43,0x1,0x30,0x6b,0x44,0x8,0x0,0x0,0x0,0x2f,0x3f,0xda,0x43,0x3d,0x83,0x6e,0x44,0x2,0x6,0xe0,0x43,0xd8,0x38,0x70,0x44,0x8e,0xdd,0xe5,0x43,0x1,0x6a,0x70,0x44,0x8,0x0,0x0,0x0,0x19,0xb5,0xeb,0x43,0x2b,0x9b,0x70,0x44,0xe8,0xa6,0xf1,0x43,0x3e,0xa4,0x6f,0x44,0x8e,0x25,0xf7,0x43,0x1,0x64,0x6e,0x44,0x8,0x0,0x0,0x0,0x6d,0x11,0x1,0x44,0x88,0xe3,0x6b,0x44,0xc7,0xc4,0x5,0x44,0x1,0x4,0x68,0x44,0xc7,0xc4,0x5,0x44,0x1,0x4,0x68,0x44,0x4,0x0,0x0,0x0,0xc8,0x48,0x2b,0x44,0x0,0x52,0x49,0x44,0x1,0x0,0x0,0x0,0x6f,0x62,0x6a,0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0xc8,0xc8,0xc8,0x0,0xc8,0x48,0x2b,0x44,0x0,0x52,0x49,0x44,0xc8,0x48,0x2b,0x44,0x0,0x52,0x49,0x44,0x1,0x3,0xc,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0xc8,0x48,0x2b,0x44,0x0,0x52,0x49,0x44,0x6f,0x62,0x6a,0x33,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0x14,0x14,0x14,0x0,0x35,0x46,0xe2,0x40,0x6c,0xbe,0x46,0x44,0xd5,0xc6,0x30,0x44,0x6e,0xe7,0x86,0x44,0x1,0x3,0x30,0x1,0x0,0x0,0x2,0x0,0x0,0x0,0xc8,0x6c,0xd3,0x43,0x28,0x5,0x86,0x44,0x4,0x0,0x0,0x0,0xc8,0x6c,0xd3,0x43,0xac,0xb4,0x74,0x44,0x8,0x0,0x0,0x0,0xc8,0x6c,0xd3,0x43,0xac,0xb4,0x74,0x44,0x31,0x3e,0xd0,0x43,0x91,0x72,0x67,0x44,0xd5,0xc6,0xb0,0x43,0xe5,0x73,0x6a,0x44,0x8,0x0,0x0,0x0,0x79,0x4f,0x91,0x43,0x3a,0x75,0x6d,0x44,0x6,0x14,0x93,0x41,0x6e,0xe7,0x86,0x44,0x6,0x14,0x93,0x41,0x6e,0xe7,0x86,0x44,0x4,0x0,0x0,0x0,0x35,0x46,0xe2,0x40,0x79,0xcf,0x83,0x44,0x4,0x0,0x0,0x0,0x1e,0x9d,0x16,0x43,0x7e,0x5b,0x77,0x44,0x4,0x0,0x0,0x0,0xe8,0xd5,0x8e,0x42,0x25,0xe0,0x4e,0x44,0x4,0x0,0x0,0x0,0x4c,0xbf,0xc1,0x42,0xd0,0xde,0x4b,0x44,0x4,0x0,0x0,0x0,0xd5,0xc6,0x30,0x43,0x25,0xa5,0x73,0x44,0x4,0x0,0x0,0x0,0x58,0x21,0xb1,0x43,0xf5,0x8e,0x63,0x44,0x8,0x0,0x0,0x0,0x58,0x21,0xb1,0x43,0xf5,0x8e,0x63,0x44,0x3b,0xa8,0xd1,0x43,0xd8,0x50,0x5f,0x44,0xfe,0x33,0xdb,0x43,0xe5,0x73,0x6a,0x44,0x8,0x0,0x0,0x0,0xc1,0xbf,0xe4,0x43,0xf3,0x96,0x75,0x44,0x61,0xc2,0x4,0x44,0x4a,0x90,0x66,0x44,0x61,0xc2,0x4,0x44,0x4a,0x90,0x66,0x44,0x4,0x0,0x0,0x0,0x71,0xa6,0x2b,0x44,0x6c,0xbe,0x46,0x44,0x4,0x0,0x0,0x0,0xd5,0xc6,0x30,0x44,0x93,0x66,0x4c,0x44,0x4,0x0,0x0,0x0,0x1a,0x7a,0xf1,0x43,0x89,0xc5,0x78,0x44,0x8,0x0,0x0,0x0,0x1a,0x7a,0xf1,0x43,0x89,0xc5,0x78,0x44,0x2b,0x91,0xe1,0x43,0x66,0xd6,0x7c,0x44,0xa8,0x36,0xe1,0x43,0xe2,0xa0,0x80,0x44,0x8,0x0,0x0,0x0,0x26,0xdc,0xe0,0x43,0x92,0xd6,0x82,0x44,0xa8,0x36,0xe1,0x43,0x69,0x32,0x86,0x44,0xa8,0x36,0xe1,0x43,0x69,0x32,0x86,0x44,0x1,0x0,0x0,0x0,0x6f,0x62,0x6a,0x33,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0x14,0x14,0x14,0x0,0xc8,0x6c,0xd3,0x43,0x28,0x5,0x86,0x44,0xc8,0x6c,0xd3,0x43,0x28,0x5,0x86,0x44,0x1,0x3,0xc,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0xc8,0x6c,0xd3,0x43,0x28,0x5,0x86,0x44,0x6f,0x62,0x6a,0x35,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0xa6,0x69,0x0,0x0,0xb8,0x88,0xac,0x42,0x88,0x0,0x54,0x44,0xbc,0xa,0xe4,0x43,0x96,0xa,0x88,0x44,0x1,0x3,0x54,0x1,0x0,0x0,0x2,0x0,0x0,0x0,0xd2,0xd6,0xd4,0x43,0x55,0xe0,0x87,0x44,0x4,0x0,0x0,0x0,0x59,0xe6,0xd5,0x43,0x26,0xa5,0x73,0x44,0x8,0x0,0x0,0x0,0x59,0xe6,0xd5,0x43,0x26,0xa5,0x73,0x44,0xaf,0xe3,0xcf,0x43,0x40,0x26,0x65,0x44,0x62,0x8b,0xb2,0x43,0xe0,0xbe,0x69,0x44,0x8,0x0,0x0,0x0,0x14,0x33,0x95,0x43,0x81,0x57,0x6e,0x44,0x7,0xd9,0x37,0x43,0x92,0x2f,0x7a,0x44,0x7,0xd9,0x37,0x43,0x92,0x2f,0x7a,0x44,0x8,0x0,0x0,0x0,0x7,0xd9,0x37,0x43,0x92,0x2f,0x7a,0x44,0x6d,0xed,0x21,0x43,0xa1,0x4e,0x7c,0x44,0x1a,0xe8,0x15,0x43,0x76,0xf1,0x75,0x44,0x8,0x0,0x0,0x0,0xc5,0xe2,0x9,0x43,0x49,0x94,0x6f,0x44,0x60,0x93,0xc4,0x42,0x0,0xf5,0x5b,0x44,0x60,0x93,0xc4,0x42,0x0,0xf5,0x5b,0x44,0x4,0x0,0x0,0x0,0xb8,0x88,0xac,0x42,0x9,0x5f,0x5d,0x44,0x4,0x0,0x0,0x0,0x2e,0x81,0xbd,0x42,0x88,0x0,0x54,0x44,0x4,0x0,0x0,0x0,0xb1,0xe,0x7,0x43,0x64,0x11,0x58,0x44,0x4,0x0,0x0,0x0,0x75,0x2c,0xec,0x42,0x32,0x3,0x5a,0x44,0x4,0x0,0x0,0x0,0x69,0x38,0x21,0x43,0x40,0x2a,0x6e,0x44,0x8,0x0,0x0,0x0,0x69,0x38,0x21,0x43,0x40,0x2a,0x6e,0x44,0x9a,0x4a,0x28,0x43,0x2a,0x5a,0x74,0x44,0x33,0x36,0x3e,0x43,0x9f,0x95,0x72,0x44,0x8,0x0,0x0,0x0,0xcd,0x21,0x54,0x43,0x12,0xd1,0x70,0x44,0xbd,0x3d,0xad,0x43,0x3b,0x71,0x64,0x44,0xbd,0x3d,0xad,0x43,0x3b,0x71,0x64,0x44,0x8,0x0,0x0,0x0,0xbd,0x3d,0xad,0x43,0x3b,0x71,0x64,0x44,0xbe,0x2,0xd2,0x43,0x2c,0x52,0x62,0x44,0xea,0x5f,0xd8,0x43,0x96,0x27,0x68,0x44,0x8,0x0,0x0,0x0,0x17,0xbd,0xde,0x43,0xfe,0xfc,0x6d,0x44,0xbc,0xa,0xe4,0x43,0x44,0xdf,0x6e,0x44,0xb2,0xa0,0xe2,0x43,0xde,0xc6,0x7b,0x44,0x8,0x0,0x0,0x0,0xa8,0x36,0xe1,0x43,0x3c,0x57,0x84,0x44,0x26,0xdc,0xe0,0x43,0x96,0xa,0x88,0x44,0x26,0xdc,0xe0,0x43,0x96,0xa,0x88,0x44,0x1,0x0,0x0,0x0,0x6f,0x62,0x6a,0x35,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0xa6,0x69,0x0,0x0,0xd2,0xd6,0xd4,0x43,0x55,0xe0,0x87,0x44,0xd2,0xd6,0xd4,0x43,0x55,0xe0,0x87,0x44,0x1,0x3,0xc,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0xd2,0xd6,0xd4,0x43,0x55,0xe0,0x87,0x44};
unsigned char vgModel_04[] = {0x1,0x0,0xef,0xbe,0x7,0x0,0x0,0x0,0x20,0x3,0x0,0x0,0xdc,0x0,0x0,0x0,0x2c,0x0,0x0,0x0,0x6f,0x2,0x0,0x0,0x5e,0x4,0x0,0x0,0xb5,0x4,0x0,0x0,0xd4,0x5,0x0,0x0,0x2b,0x6,0x0,0x0,0x3e,0x7,0x0,0x0,0x6f,0x62,0x6a,0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0xc8,0xc8,0xc8,0x0,0x0,0x8,0x32,0x43,0x0,0xd6,0x4e,0x44,0x0,0x24,0x46,0x44,0x0,0xf9,0x87,0x44,0x1,0x3,0xf8,0x1,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x28,0x4c,0x43,0x0,0xd6,0x4e,0x44,0x4,0x0,0x0,0x0,0x0,0xf8,0x48,0x43,0x0,0x84,0x4f,0x44,0x4,0x0,0x0,0x0,0x0,0x90,0x36,0x43,0x0,0x66,0x53,0x44,0x4,0x0,0x0,0x0,0x0,0x8,0x32,0x43,0x0,0x5c,0x54,0x44,0x4,0x0,0x0,0x0,0x0,0x98,0x36,0x43,0x0,0x50,0x55,0x44,0x4,0x0,0x0,0x0,0x0,0xd0,0xb8,0x43,0x0,0x8c,0x7c,0x44,0x4,0x0,0x0,0x0,0x0,0x28,0xb9,0x43,0x0,0x5a,0x87,0x44,0x4,0x0,0x0,0x0,0xfe,0x2b,0xb9,0x43,0x0,0xf9,0x87,0x44,0x4,0x0,0x0,0x0,0xfe,0xa7,0xbb,0x43,0x0,0xf9,0x87,0x44,0x4,0x0,0x0,0x0,0xfe,0x43,0xc6,0x43,0x0,0xf9,0x87,0x44,0x4,0x0,0x0,0x0,0xfe,0xc7,0xc8,0x43,0x0,0xf9,0x87,0x44,0x4,0x0,0x0,0x0,0x0,0xc4,0xc8,0x43,0x0,0x58,0x87,0x44,0x8,0x0,0x0,0x0,0x0,0xc4,0xc8,0x43,0x0,0x58,0x87,0x44,0xc5,0x66,0xc8,0x43,0xc8,0x2e,0x74,0x44,0x0,0xc,0xc8,0x43,0x0,0x9c,0x6a,0x44,0x8,0x0,0x0,0x0,0x50,0xf6,0xc7,0x43,0x73,0x52,0x68,0x44,0xb9,0x79,0xc8,0x43,0xf7,0xd5,0x66,0x44,0x0,0x20,0xc9,0x43,0x0,0xf6,0x65,0x44,0x8,0x0,0x0,0x0,0x47,0xc6,0xc9,0x43,0x9,0x16,0x65,0x44,0x49,0x70,0xca,0x43,0x2b,0xd8,0x64,0x44,0x0,0xe8,0xca,0x43,0x0,0xbc,0x64,0x44,0x8,0x0,0x0,0x0,0x6e,0xd7,0xcb,0x43,0xaa,0x83,0x64,0x44,0x0,0x24,0xcd,0x43,0x0,0xd2,0x64,0x44,0x0,0x24,0xcd,0x43,0x0,0xd2,0x64,0x44,0x4,0x0,0x0,0x0,0x0,0x5c,0xcd,0x43,0x0,0xe2,0x64,0x44,0x4,0x0,0x0,0x0,0x0,0x98,0xcd,0x43,0x0,0xec,0x64,0x44,0x4,0x0,0x0,0x0,0x0,0x7e,0x44,0x44,0x0,0x31,0x82,0x44,0x4,0x0,0x0,0x0,0x0,0x24,0x46,0x44,0x0,0x78,0x82,0x44,0x4,0x0,0x0,0x0,0x0,0x24,0x46,0x44,0x0,0x9a,0x81,0x44,0x4,0x0,0x0,0x0,0x0,0x24,0x46,0x44,0x0,0x14,0x7e,0x44,0x4,0x0,0x0,0x0,0x0,0x24,0x46,0x44,0x1,0x2e,0x7d,0x44,0x4,0x0,0x0,0x0,0x0,0x4c,0x45,0x44,0x0,0xe4,0x7c,0x44,0x8,0x0,0x0,0x0,0x0,0x4c,0x45,0x44,0x0,0xe4,0x7c,0x44,0x6f,0xea,0xfd,0x43,0xf4,0xad,0x64,0x44,0x0,0x6c,0xd9,0x43,0x0,0xa8,0x5e,0x44,0x8,0x0,0x0,0x0,0xe2,0x10,0xd0,0x43,0xb0,0x1c,0x5d,0x44,0x41,0x45,0xc9,0x43,0x50,0xcc,0x5c,0x44,0x0,0x24,0xc4,0x43,0x0,0x54,0x5d,0x44,0x8,0x0,0x0,0x0,0xbf,0x2,0xbf,0x43,0xb0,0xdb,0x5d,0x44,0x67,0xa7,0xbb,0x43,0x10,0x57,0x5f,0x44,0x0,0xec,0xb9,0x43,0x0,0xfe,0x60,0x44,0x8,0x0,0x0,0x0,0x59,0xb5,0xb6,0x43,0xaf,0xe,0x64,0x44,0xd4,0x32,0xb8,0x43,0xc8,0x6a,0x67,0x44,0x0,0x70,0xb8,0x43,0x0,0xe8,0x67,0x44,0x4,0x0,0x0,0x0,0x0,0xb8,0xb8,0x43,0x0,0x4a,0x71,0x44,0x4,0x0,0x0,0x0,0x0,0x60,0x4f,0x43,0x0,0x82,0x4f,0x44,0x4,0x0,0x0,0x0,0x0,0x28,0x4c,0x43,0x0,0xd6,0x4e,0x44,0x1,0x0,0x0,0x0,0x6f,0x62,0x6a,0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0xc8,0xc8,0xc8,0x0,0x3,0x90,0x41,0x43,0x0,0x1a,0x52,0x44,0xff,0xa3,0x43,0x44,0x0,0xb9,0x86,0x44,0x1,0x3,0xa4,0x1,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x28,0x4c,0x43,0x0,0xd6,0x4e,0x44,0x2,0x0,0x0,0x0,0xfd,0x2f,0x4c,0x43,0x0,0x1a,0x52,0x44,0x4,0x0,0x0,0x0,0xfe,0xb3,0xb9,0x43,0x0,0xf6,0x74,0x44,0x4,0x0,0x0,0x0,0xfe,0xdf,0xbd,0x43,0x0,0xb4,0x76,0x44,0x4,0x0,0x0,0x0,0xfe,0xcb,0xbd,0x43,0x0,0xfc,0x73,0x44,0x4,0x0,0x0,0x0,0xfe,0x6f,0xbd,0x43,0x0,0xc8,0x67,0x44,0x4,0x0,0x0,0x0,0xfe,0x6f,0xbd,0x43,0x0,0xa4,0x67,0x44,0x4,0x0,0x0,0x0,0xfe,0x5f,0xbd,0x43,0x0,0x82,0x67,0x44,0x8,0x0,0x0,0x0,0xfe,0x5f,0xbd,0x43,0x0,0x82,0x67,0x44,0x3,0x14,0xbc,0x43,0x7,0x53,0x64,0x44,0xfe,0x5b,0xbe,0x43,0x0,0x26,0x62,0x44,0x8,0x0,0x0,0x0,0xfc,0x7f,0xbf,0x43,0x7c,0xf,0x61,0x44,0xbc,0x49,0xc1,0x43,0xe7,0x2d,0x60,0x44,0xfe,0x23,0xc5,0x43,0x0,0xc8,0x5f,0x44,0x8,0x0,0x0,0x0,0x40,0xfe,0xc8,0x43,0x19,0x62,0x5f,0x44,0xdd,0x1,0xcf,0x43,0xfa,0x91,0x5f,0x44,0xfe,0xdb,0xd7,0x43,0x0,0x8,0x61,0x44,0x8,0x0,0x0,0x0,0xae,0xca,0xfb,0x43,0x3a,0xf6,0x66,0x44,0x3,0x1a,0x42,0x44,0x64,0x70,0x7e,0x44,0xff,0xa3,0x43,0x44,0x0,0xf8,0x7e,0x44,0x4,0x0,0x0,0x0,0xff,0xa3,0x43,0x44,0x0,0xbb,0x80,0x44,0x4,0x0,0x0,0x0,0x0,0x44,0xcf,0x43,0x0,0x90,0x62,0x44,0x8,0x0,0x0,0x0,0xc2,0x70,0xce,0x43,0x5c,0x59,0x62,0x44,0x13,0xc7,0xcb,0x43,0x83,0xc3,0x61,0x44,0x0,0xc8,0xc8,0x43,0x0,0x78,0x62,0x44,0x8,0x0,0x0,0x0,0xb7,0xfe,0xc6,0x43,0x99,0xe3,0x62,0x44,0x81,0x69,0xc5,0x43,0xef,0xc7,0x63,0x44,0x0,0x70,0xc4,0x43,0x0,0x18,0x65,0x44,0x8,0x0,0x0,0x0,0x7f,0x76,0xc3,0x43,0x11,0x68,0x66,0x44,0x6f,0xf4,0xc2,0x43,0xab,0x2b,0x68,0x44,0x0,0xc,0xc3,0x43,0x0,0xa8,0x6a,0x44,0x8,0x0,0x0,0x0,0x1a,0x63,0xc3,0x43,0xb7,0xd7,0x73,0x44,0x0,0xb6,0xc3,0x43,0xd5,0xda,0x85,0x44,0x0,0xbc,0xc3,0x43,0x0,0xb9,0x86,0x44,0x4,0x0,0x0,0x0,0x0,0x20,0xbe,0x43,0x0,0xb9,0x86,0x44,0x4,0x0,0x0,0x0,0x0,0xcc,0xbd,0x43,0xff,0xf1,0x7b,0x44,0x4,0x0,0x0,0x0,0x2,0xc8,0xbd,0x43,0x1,0x5e,0x7b,0x44,0x4,0x0,0x0,0x0,0x2,0xe8,0xbc,0x43,0x1,0xfe,0x7a,0x44,0x4,0x0,0x0,0x0,0x3,0x90,0x41,0x43,0x0,0x5a,0x54,0x44,0x4,0x0,0x0,0x0,0x3,0x30,0x4c,0x43,0x0,0x1a,0x52,0x44,0x1,0x0,0x0,0x0,0x6f,0x62,0x6a,0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0xc8,0xc8,0xc8,0x0,0xfd,0x2f,0x4c,0x43,0x0,0x1a,0x52,0x44,0xfd,0x2f,0x4c,0x43,0x0,0x1a,0x52,0x44,0x1,0x3,0xc,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0xfd,0x2f,0x4c,0x43,0x0,0x1a,0x52,0x44,0x6f,0x62,0x6a,0x33,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0x14,0x14,0x14,0x0,0xa3,0x81,0x3a,0x43,0xb0,0xa4,0x50,0x44,0x45,0x10,0x45,0x44,0x33,0x6f,0x87,0x44,0x1,0x3,0xd4,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x68,0x1,0xbc,0x43,0x33,0x6f,0x87,0x44,0x4,0x0,0x0,0x0,0xe6,0xa6,0xbb,0x43,0x62,0x21,0x7c,0x44,0x4,0x0,0x0,0x0,0xa3,0x81,0x3a,0x43,0x4b,0x88,0x54,0x44,0x4,0x0,0x0,0x0,0x24,0xe4,0x4c,0x43,0xb0,0xa4,0x50,0x44,0x4,0x0,0x0,0x0,0xe6,0xa6,0xbb,0x43,0xea,0x2c,0x74,0x44,0x4,0x0,0x0,0x0,0x63,0x4c,0xbb,0x43,0x54,0xfa,0x67,0x44,0x8,0x0,0x0,0x0,0x63,0x4c,0xbb,0x43,0x54,0xfa,0x67,0x44,0xb4,0x94,0xb4,0x43,0x31,0x3,0x5a,0x44,0x33,0xff,0xd8,0x43,0xdc,0x5,0x60,0x44,0x8,0x0,0x0,0x0,0xb2,0x69,0xfd,0x43,0x86,0x8,0x66,0x44,0x45,0x10,0x45,0x44,0x71,0x40,0x7e,0x44,0x45,0x10,0x45,0x44,0x71,0x40,0x7e,0x44,0x4,0x0,0x0,0x0,0x45,0x10,0x45,0x44,0x6a,0xb0,0x81,0x44,0x4,0x0,0x0,0x0,0x6b,0xbe,0xce,0x43,0x77,0xe9,0x63,0x44,0x8,0x0,0x0,0x0,0x6b,0xbe,0xce,0x43,0x77,0xe9,0x63,0x44,0x2b,0x8d,0xc5,0x43,0xa4,0x42,0x61,0x44,0xad,0xe7,0xc5,0x43,0x67,0xce,0x6a,0x44,0x8,0x0,0x0,0x0,0x30,0x42,0xc6,0x43,0x2c,0x5a,0x74,0x44,0xb3,0x9c,0xc6,0x43,0x33,0x6f,0x87,0x44,0xb3,0x9c,0xc6,0x43,0x33,0x6f,0x87,0x44,0x1,0x0,0x0,0x0,0x6f,0x62,0x6a,0x33,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0x14,0x14,0x14,0x0,0x68,0x1,0xbc,0x43,0x33,0x6f,0x87,0x44,0x68,0x1,0xbc,0x43,0x33,0x6f,0x87,0x44,0x1,0x3,0xc,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x68,0x1,0xbc,0x43,0x33,0x6f,0x87,0x44,0x6f,0x62,0x6a,0x35,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0xa6,0x69,0x0,0x0,0xf5,0x8e,0x58,0x43,0x97,0x9f,0x56,0x44,0xef,0x14,0xc6,0x43,0xfb,0xeb,0x88,0x44,0x1,0x3,0xc8,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x28,0xd4,0xbb,0x43,0xfb,0xeb,0x88,0x44,0x4,0x0,0x0,0x0,0x2c,0x89,0xbc,0x43,0xed,0x65,0x7e,0x44,0x8,0x0,0x0,0x0,0x2c,0x89,0xbc,0x43,0xed,0x65,0x7e,0x44,0x36,0xf3,0xbd,0x43,0xdb,0x91,0x7b,0x44,0x7d,0xd1,0xb5,0x43,0x9,0xeb,0x78,0x44,0x8,0x0,0x0,0x0,0xc5,0xaf,0xad,0x43,0x37,0x44,0x76,0x44,0x40,0x2a,0x63,0x43,0x41,0xa2,0x5c,0x44,0x40,0x2a,0x63,0x43,0x41,0xa2,0x5c,0x44,0x4,0x0,0x0,0x0,0xf5,0x8e,0x58,0x43,0x96,0xa3,0x5f,0x44,0x4,0x0,0x0,0x0,0xfa,0x43,0x59,0x43,0x1f,0xaf,0x57,0x44,0x4,0x0,0x0,0x0,0x8d,0x23,0x81,0x43,0x97,0x9f,0x56,0x44,0x4,0x0,0x0,0x0,0xb7,0x22,0x74,0x43,0xb0,0x28,0x5a,0x44,0x4,0x0,0x0,0x0,0x9b,0xf,0xba,0x43,0x67,0x52,0x74,0x44,0x8,0x0,0x0,0x0,0x9b,0xf,0xba,0x43,0x67,0x52,0x74,0x44,0xef,0x14,0xc6,0x43,0xbd,0x53,0x77,0x44,0x6d,0xba,0xc5,0x43,0x2e,0x93,0x7e,0x44,0x8,0x0,0x0,0x0,0xea,0x5f,0xc5,0x43,0x51,0xe9,0x82,0x44,0x6d,0xba,0xc5,0x43,0xfb,0xeb,0x88,0x44,0x6d,0xba,0xc5,0x43,0xfb,0xeb,0x88,0x44,0x1,0x0,0x0,0x0,0x6f,0x62,0x6a,0x35,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x2e,0x17,0x50,0xc4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x3f,0x1,0xa6,0x69,0x0,0x0,0x28,0xd4,0xbb,0x43,0xfb,0xeb,0x88,0x44,0x28,0xd4,0xbb,0x43,0xfb,0xeb,0x88,0x44,0x1,0x3,0xc,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x28,0xd4,0xbb,0x43,0xfb,0xeb,0x88,0x44};
